/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.chunkoverlays;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.zergatul.cheatutils.chunkoverlays.AbstractChunkOverlay;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.ExplorationMiniMapConfig;
import com.zergatul.cheatutils.render.Primitives;
import com.zergatul.cheatutils.utils.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;

public class ExplorationMiniMapChunkOverlay
extends AbstractChunkOverlay {
    private static final ResourceLocation PlayerPosTexture = new ResourceLocation("cheatutils", "textures/mini-map-player.png");
    private static final ResourceLocation CenterPosTexture = new ResourceLocation("cheatutils", "textures/mini-map-center.png");
    private static final ResourceLocation MarkerTexture = new ResourceLocation("cheatutils", "textures/mini-map-marker.png");
    private final Map<Dimension, List<Marker>> markers = new HashMap<Dimension, List<Marker>>();

    public ExplorationMiniMapChunkOverlay(int segmentSize, long updateDelay) {
        super(segmentSize, updateDelay);
    }

    public void addMarker() {
        if (this.mc.f_91074_ != null) {
            this.addMarker(this.mc.f_91074_.m_20185_(), this.mc.f_91074_.m_20189_());
        }
    }

    public void addMarker(double x, double z) {
        Marker marker;
        Dimension dimension;
        List list;
        if (this.mc.f_91074_ != null && this.mc.f_91073_ != null && !(list = this.markers.computeIfAbsent(dimension = Dimension.get(this.mc.f_91073_), d -> new ArrayList())).contains(marker = new Marker(x, z))) {
            list.add(marker);
        }
    }

    public void clearMarkers() {
        if (this.mc.f_91073_ != null) {
            Dimension dimension = Dimension.get(this.mc.f_91073_);
            this.markers.computeIfAbsent(dimension, d -> new ArrayList()).clear();
        }
    }

    @Override
    public int getTranslateZ() {
        return 100;
    }

    @Override
    public boolean isEnabled() {
        return this.getConfig().enabled;
    }

    @Override
    public void onPostDrawSegments(Dimension dimension, PoseStack poseStack, float xp, float zp, float xc, float zc, float multiplier) {
        int ImageSize = 8;
        for (Marker marker : this.markers.computeIfAbsent(dimension, d -> new ArrayList())) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)MarkerTexture);
            Primitives.drawTexture(poseStack.m_85850_().m_252922_(), -4.0f + ((float)marker.x - xc) * multiplier, -4.0f + ((float)marker.z - zc) * multiplier, 8.0f, 8.0f, this.getTranslateZ() + 2, 0, 0, 8, 8, 8, 8);
        }
        double distanceToPlayer = Math.sqrt((xp - xc) * (xp - xc) + (zp - zc) * (zp - zc));
        if (distanceToPlayer * (double)multiplier > 16.0) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)CenterPosTexture);
            Primitives.drawTexture(poseStack.m_85850_().m_252922_(), -4.0f, -4.0f, 8.0f, 8.0f, this.getTranslateZ() + 3, 0, 0, 8, 8, 8, 8);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)PlayerPosTexture);
        Primitives.drawTexture(poseStack.m_85850_().m_252922_(), -4.0f + (xp - xc) * multiplier, -4.0f + (zp - zc) * multiplier, 8.0f, 8.0f, this.getTranslateZ() + 4, 0, 0, 8, 8, 8, 8);
    }

    @Override
    protected boolean drawChunk(Dimension dimension, Map<AbstractChunkOverlay.SegmentPos, AbstractChunkOverlay.Segment> segments, LevelChunk chunk) {
        if (chunk.m_6415_() != ChunkStatus.f_62326_) {
            return false;
        }
        ChunkPos chunkPos = chunk.m_7697_();
        AbstractChunkOverlay.SegmentPos segmentPos = new AbstractChunkOverlay.SegmentPos(chunkPos, this.segmentSize);
        this.addToRenderQueue(new AbstractChunkOverlay.RenderThreadQueueItem(() -> {
            if (!segments.containsKey(segmentPos)) {
                segments.put(segmentPos, new AbstractChunkOverlay.Segment(segmentPos, this.segmentSize));
            }
        }, () -> {
            AbstractChunkOverlay.Segment segment = (AbstractChunkOverlay.Segment)segments.get(segmentPos);
            int xf = Math.floorMod(chunkPos.f_45578_, this.segmentSize) * 16;
            int yf = Math.floorMod(chunkPos.f_45579_, this.segmentSize) * 16;
            Integer scanFromY = this.getConfig().scanFromY;
            for (int dx = 0; dx < 16; ++dx) {
                for (int dz = 0; dz < 16; ++dz) {
                    this.drawPixel(dimension, xf, yf, dx, dz, segment, chunk, scanFromY);
                }
            }
            this.addToRenderQueue(new AbstractChunkOverlay.RenderThreadQueueItem(segment::onChange));
        }));
        return true;
    }

    @Override
    protected void processBlockChange(Dimension dimension, ChunkPos chunkPos, AbstractChunkOverlay.Segment segment, BlockPos pos, BlockState state) {
        if (this.mc.f_91073_ == null || segment == null) {
            return;
        }
        if (dimension.isNether()) {
            int yf;
            int xf = Math.floorMod(chunkPos.f_45578_, this.segmentSize) * 16;
            boolean updated = this.drawPixel(dimension, xf, yf = Math.floorMod(chunkPos.f_45579_, this.segmentSize) * 16, Math.floorMod(pos.m_123341_(), 16), Math.floorMod(pos.m_123343_(), 16), segment, this.mc.f_91073_.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_), this.getConfig().scanFromY);
            if (updated && !segment.updated) {
                segment.updated = true;
                segment.updateTime = System.nanoTime();
                this.addUpdatedSegment(segment);
            }
        } else {
            int yf;
            int xf;
            boolean updated;
            LevelChunk chunk = this.mc.f_91073_.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
            int dx = Math.floorMod(pos.m_123341_(), 16);
            int dz = Math.floorMod(pos.m_123343_(), 16);
            int height = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, dx, dz);
            if (pos.m_123342_() >= height && (updated = this.drawPixel(dimension, xf = Math.floorMod(chunkPos.f_45578_, this.segmentSize) * 16, yf = Math.floorMod(chunkPos.f_45579_, this.segmentSize) * 16, dx, dz, segment, chunk, this.getConfig().scanFromY)) && !segment.updated) {
                segment.updated = true;
                segment.updateTime = System.nanoTime();
                this.addUpdatedSegment(segment);
            }
        }
    }

    @Override
    protected String getThreadName() {
        return "ExplorationMiniMapScanThread";
    }

    private boolean drawPixel(Dimension dimension, int xf, int yf, int dx, int dz, AbstractChunkOverlay.Segment segment, LevelChunk chunk, Integer scanFromY) {
        int height;
        MapColor materialColor;
        if (dimension.hasCeiling() || scanFromY != null) {
            int y1;
            int n = y1 = scanFromY != null ? scanFromY : dimension.getMinY() + dimension.getLogicalHeight() - 1;
            while (y1 >= dimension.getMinY()) {
                BlockPos pos = new BlockPos(dx, y1, dz);
                BlockState state = chunk.m_8055_(pos);
                if (state.m_60795_()) {
                    for (int y2 = y1 - 1; y2 >= dimension.getMinY(); --y2) {
                        pos = new BlockPos(dx, y2, dz);
                        state = chunk.m_8055_(pos);
                        if (state.m_60795_() || (materialColor = state.m_284242_((BlockGetter)this.mc.f_91073_, pos)) == MapColor.f_283808_) continue;
                        int color = ExplorationMiniMapChunkOverlay.convert(materialColor.f_283871_);
                        if (segment.image.m_84985_(xf + dx, yf + dz) != color) {
                            segment.image.m_84988_(xf + dx, yf + dz, color);
                            return true;
                        }
                        return false;
                    }
                    break;
                }
                --y1;
            }
        }
        for (int y = height = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, dx, dz); y >= dimension.getMinY(); --y) {
            BlockPos pos = new BlockPos(dx, y, dz);
            BlockState state = chunk.m_8055_(pos);
            materialColor = state.m_284242_((BlockGetter)this.mc.f_91073_, pos);
            if (materialColor == MapColor.f_283808_) continue;
            int color = ExplorationMiniMapChunkOverlay.convert(materialColor.f_283871_);
            if (segment.image.m_84985_(xf + dx, yf + dz) != color) {
                segment.image.m_84988_(xf + dx, yf + dz, color);
                return true;
            }
            return false;
        }
        return false;
    }

    private ExplorationMiniMapConfig getConfig() {
        return ConfigStore.instance.getConfig().explorationMiniMapConfig;
    }

    private static int convert(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        return 0xFF000000 | blue << 16 | green << 8 | red;
    }

    public static class Marker {
        public int x;
        public int z;

        public Marker(double x, double z) {
            this.x = (int)Math.round(x);
            this.z = (int)Math.round(z);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Marker) {
                Marker other = (Marker)obj;
                return this.x == other.x && this.z == other.z;
            }
            return false;
        }
    }
}

