/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.chunkoverlays;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.zergatul.cheatutils.controllers.ChunkController;
import com.zergatul.cheatutils.utils.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;

public abstract class AbstractChunkOverlay {
    protected final Minecraft mc = Minecraft.m_91087_();
    protected final int segmentSize;
    private final long updateDelay;
    private final Map<Dimension, Map<SegmentPos, Segment>> dimensions = new ConcurrentHashMap<Dimension, Map<SegmentPos, Segment>>();
    private final Object loopWaitEvent = new Object();
    private final Thread eventLoop;
    private final Queue<Runnable> queue = new ConcurrentLinkedQueue<Runnable>();
    private final Queue<Runnable> endTickQueue = new ConcurrentLinkedQueue<Runnable>();
    private final Queue<RenderThreadQueueItem> renderQueue = new ConcurrentLinkedQueue<RenderThreadQueueItem>();
    private final Set<Segment> updatedSegments = new HashSet<Segment>();
    private final List<Segment> textureUploaded = new ArrayList<Segment>();

    protected AbstractChunkOverlay(int segmentSize, long updateDelay) {
        this.segmentSize = segmentSize;
        this.updateDelay = updateDelay;
        this.eventLoop = new Thread(this::eventLoopThreadFunc, this.getThreadName());
        this.eventLoop.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onEnabledChanged() {
        if (this.isEnabled()) {
            ChunkController.instance.getLoadedChunks().forEach(p -> this.onChunkLoaded((Dimension)p.getFirst(), (LevelChunk)p.getSecond()));
        } else {
            this.queue.add(() -> {
                this.renderQueue.clear();
                this.endTickQueue.clear();
                this.queue.clear();
                for (Map<SegmentPos, Segment> segments : this.dimensions.values()) {
                    for (Segment segment : segments.values()) {
                        segment.close();
                    }
                    segments.clear();
                }
            });
            Object object = this.loopWaitEvent;
            synchronized (object) {
                this.loopWaitEvent.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onChunkLoaded(Dimension dimension, LevelChunk chunk) {
        if (!this.isEnabled()) {
            return;
        }
        Map<SegmentPos, Segment> segments = this.getSegmentsMap(dimension);
        this.queue.add(() -> {
            if (!this.drawChunk(dimension, segments, chunk)) {
                this.onChunkLoaded(dimension, chunk);
            }
        });
        Object object = this.loopWaitEvent;
        synchronized (object) {
            this.loopWaitEvent.notify();
        }
    }

    public final void onBlockChanged(Dimension dimension, BlockPos pos, BlockState state) {
        if (!this.isEnabled()) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        SegmentPos segmentPos = new SegmentPos(chunkPos, this.segmentSize);
        Map segments = this.dimensions.computeIfAbsent(dimension, d -> new HashMap());
        Segment segment = (Segment)segments.get(segmentPos);
        this.endTickQueue.add(() -> this.processBlockChange(dimension, chunkPos, segment, pos, state));
    }

    public final void onClientTickEnd() {
        while (this.endTickQueue.size() > 0) {
            this.endTickQueue.remove().run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onPreRender() {
        Object item;
        boolean shouldNotify;
        boolean bl = shouldNotify = this.renderQueue.size() > 0;
        while (this.renderQueue.size() > 0) {
            item = this.renderQueue.remove();
            ((RenderThreadQueueItem)item).runnable.run();
            if (((RenderThreadQueueItem)item).continuation == null) continue;
            this.queue.add(((RenderThreadQueueItem)item).continuation);
        }
        if (shouldNotify) {
            item = this.loopWaitEvent;
            synchronized (item) {
                this.loopWaitEvent.notify();
            }
        }
        this.textureUploaded.clear();
        long now = System.nanoTime();
        for (Segment segment : this.updatedSegments) {
            if (now - segment.updateTime <= this.updateDelay) continue;
            segment.onChange();
            segment.updated = false;
            segment.updateTime = 0L;
            this.textureUploaded.add(segment);
        }
        for (Segment segment : this.textureUploaded) {
            this.updatedSegments.remove(segment);
        }
    }

    public final Collection<Segment> getSegments(Dimension dimension) {
        return this.getSegmentsMap(dimension).values();
    }

    public final int getScanningQueueCount() {
        return this.queue.size();
    }

    public final String getThreadState() {
        Thread thread = this.eventLoop;
        if (thread != null) {
            return this.eventLoop.getState().toString();
        }
        return null;
    }

    public abstract int getTranslateZ();

    public abstract boolean isEnabled();

    public void onPostDrawSegments(Dimension dimension, PoseStack poseStack, float xp, float zp, float xc, float zc, float multiplier) {
    }

    protected final Map<SegmentPos, Segment> getSegmentsMap(Dimension dimension) {
        return this.dimensions.computeIfAbsent(dimension, d -> new HashMap());
    }

    protected abstract boolean drawChunk(Dimension var1, Map<SegmentPos, Segment> var2, LevelChunk var3);

    protected abstract void processBlockChange(Dimension var1, ChunkPos var2, Segment var3, BlockPos var4, BlockState var5);

    protected final void addToRenderQueue(RenderThreadQueueItem item) {
        this.renderQueue.add(item);
    }

    protected final void addUpdatedSegment(Segment segment) {
        this.updatedSegments.add(segment);
    }

    protected abstract String getThreadName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eventLoopThreadFunc() {
        try {
            block6: while (true) {
                Object object = this.loopWaitEvent;
                synchronized (object) {
                    this.loopWaitEvent.wait();
                }
                while (true) {
                    if (this.queue.size() <= 0) continue block6;
                    this.queue.remove().run();
                    Thread.yield();
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class SegmentPos {
        public int x;
        public int z;

        public SegmentPos(ChunkPos pos, int segmentSize) {
            this.x = Math.floorDiv(pos.f_45578_, segmentSize);
            this.z = Math.floorDiv(pos.f_45579_, segmentSize);
        }

        public int hashCode() {
            return Objects.hash(this.x, this.z);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SegmentPos)) {
                return false;
            }
            SegmentPos pos = (SegmentPos)obj;
            return this.x == pos.x && this.z == pos.z;
        }
    }

    public static class Segment {
        public final SegmentPos pos;
        public final NativeImage image;
        public final DynamicTexture texture;
        public boolean updated;
        public long updateTime;

        public Segment(SegmentPos pos, int segmentSize) {
            this.pos = pos;
            this.image = new NativeImage(segmentSize * 16, segmentSize * 16, true);
            this.texture = new DynamicTexture(this.image);
        }

        public void onChange() {
            this.texture.m_117985_();
        }

        public void close() {
            this.texture.close();
        }

        public int hashCode() {
            return this.pos.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Segment)) {
                return false;
            }
            Segment segment = (Segment)obj;
            return this.pos.equals(segment.pos);
        }
    }

    protected static class RenderThreadQueueItem {
        public Runnable runnable;
        public Runnable continuation;

        public RenderThreadQueueItem(Runnable runnable) {
            this.runnable = runnable;
        }

        public RenderThreadQueueItem(Runnable runnable, Runnable continuation) {
            this.runnable = runnable;
            this.continuation = continuation;
        }
    }
}

