/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.bendylib.impl;

import io.github.kosmx.bendylib.impl.IterableRePos;
import net.minecraft.core.Direction;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public interface IBendable {
    default public Matrix4f applyBend(float bendAxis, float bendValue, IterableRePos posSupplier) {
        Vector3f axis = new Vector3f((float)Math.cos(bendAxis), 0.0f, (float)Math.sin(bendAxis));
        Matrix3f matrix3f = new Matrix3f().set((Quaternionfc)this.getBendDirection().m_253075_());
        axis.mul((Matrix3fc)matrix3f);
        Matrix4f transformMatrix = new Matrix4f();
        transformMatrix.translate(this.getBendX(), this.getBendY(), this.getBendZ());
        transformMatrix.rotate(bendValue, (Vector3fc)axis);
        transformMatrix.translate(-this.getBendX(), -this.getBendY(), -this.getBendZ());
        Plane basePlane = this.getBasePlane();
        Plane otherPlane = this.getOtherSidePlane();
        Vector3f directionUnit = this.getBendDirection().m_253071_();
        directionUnit.cross((Vector3fc)axis);
        Plane bendPlane = new Plane(directionUnit, new Vector3f(this.getBendX(), this.getBendY(), this.getBendZ()));
        float halfSize = this.bendHeight() / 2.0f;
        boolean bl = this.isBendInverted();
        posSupplier.iteratePositions(iPosWithOrigin -> {
            Vector3f newPos = iPosWithOrigin.getOriginalPos();
            float distFromBend = bl ? -bendPlane.distanceTo(newPos) : bendPlane.distanceTo(newPos);
            float distFromBase = basePlane.distanceTo(newPos);
            float distFromOther = otherPlane.distanceTo(newPos);
            double s = Math.tan(bendValue / 2.0f) * (double)distFromBend;
            Vector3f x = this.getBendDirection().m_253071_();
            if (Math.abs(distFromBase) < Math.abs(distFromOther)) {
                x.mul((float)((double)(-distFromBase / halfSize) * s));
                newPos.add((Vector3fc)x);
                Vector4f reposVector = new Vector4f((Vector3fc)newPos, 1.0f);
                reposVector.mul((Matrix4fc)transformMatrix);
                newPos = new Vector3f(reposVector.x, reposVector.y, reposVector.z);
            } else {
                x.mul((float)((double)(-distFromOther / halfSize) * s));
                newPos.add((Vector3fc)x);
            }
            iPosWithOrigin.setPos(newPos);
        });
        return transformMatrix;
    }

    default public boolean isBendInverted() {
        return this.getBendDirection() == Direction.UP || this.getBendDirection() == Direction.SOUTH || this.getBendDirection() == Direction.EAST;
    }

    public Direction getBendDirection();

    public float getBendX();

    public float getBendY();

    public float getBendZ();

    public Plane getBasePlane();

    public Plane getOtherSidePlane();

    default public float bendHeight() {
        return this.getBasePlane().distanceTo(this.getOtherSidePlane());
    }

    public static final class Plane {
        public final Vector3f normal;
        private final float normDistance;

        public Plane(Vector3f normal, Vector3f position) {
            this.normal = normal;
            this.normal.normalize();
            this.normDistance = -this.normal.dot((Vector3fc)position);
        }

        private Plane(Vector3f normal, float normDistance) {
            this.normal = normal;
            this.normDistance = normDistance;
        }

        public Plane scaled(float scalar) {
            return new Plane(new Vector3f((Vector3fc)this.normal), this.normDistance * scalar);
        }

        public float distanceTo(Vector3f pos) {
            return this.normal.dot((Vector3fc)pos) + this.normDistance;
        }

        public float distanceTo(Plane otherPlane) {
            Vector3f tmp = new Vector3f((Vector3fc)this.normal);
            tmp.cross((Vector3fc)otherPlane.normal);
            if ((double)tmp.dot((Vector3fc)tmp) < 0.01) {
                return this.normDistance + this.normal.dot((Vector3fc)otherPlane.normal) * otherPlane.normDistance;
            }
            return 0.0f;
        }
    }
}

