/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.bendylib.impl;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.kosmx.bendylib.ICuboidBuilder;
import io.github.kosmx.bendylib.impl.IBendable;
import io.github.kosmx.bendylib.impl.ICuboid;
import io.github.kosmx.bendylib.impl.IPosWithOrigin;
import io.github.kosmx.bendylib.impl.IVertex;
import io.github.kosmx.bendylib.impl.IterableRePos;
import io.github.kosmx.bendylib.impl.RememberingPos;
import io.github.kosmx.bendylib.impl.RepositionableVertex;
import io.github.kosmx.bendylib.impl.accessors.DirectionMutator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Direction;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class BendableCuboid
implements ICuboid,
IBendable,
IterableRePos {
    protected final Quad[] sides;
    protected final RememberingPos[] positions;
    protected Matrix4f lastPosMatrix;
    public final float minX;
    public final float minY;
    public final float minZ;
    public final float maxX;
    public final float maxY;
    public final float maxZ;
    protected final float fixX;
    protected final float fixY;
    protected final float fixZ;
    protected final Direction direction;
    protected final IBendable.Plane basePlane;
    protected final IBendable.Plane otherPlane;
    protected final float fullSize;
    private float bend;
    private float bendAxis;

    protected BendableCuboid(Quad[] sides, RememberingPos[] positions, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float fixX, float fixY, float fixZ, Direction direction, IBendable.Plane basePlane, IBendable.Plane otherPlane, float fullSize) {
        this.sides = sides;
        this.positions = positions;
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.fixX = fixX;
        this.fixY = fixY;
        this.fixZ = fixZ;
        this.direction = direction;
        this.basePlane = basePlane;
        this.otherPlane = otherPlane;
        this.fullSize = fullSize;
        this.applyBend(0.0f, 0.0f);
    }

    public Matrix4f applyBend(float bendAxis, float bendValue) {
        this.bend = bendValue;
        this.bendAxis = bendAxis;
        return this.applyBend(bendAxis, bendValue, this);
    }

    @Override
    public Direction getBendDirection() {
        return this.direction;
    }

    @Override
    public float getBendX() {
        return this.fixX;
    }

    @Override
    public float getBendY() {
        return this.fixY;
    }

    @Override
    public float getBendZ() {
        return this.fixZ;
    }

    @Override
    public IBendable.Plane getBasePlane() {
        return this.basePlane;
    }

    @Override
    public IBendable.Plane getOtherSidePlane() {
        return this.otherPlane;
    }

    @Override
    public float bendHeight() {
        return this.fullSize;
    }

    @Override
    public void iteratePositions(Consumer<IPosWithOrigin> consumer) {
        for (RememberingPos pos : this.positions) {
            consumer.accept(pos);
        }
    }

    public float getBend() {
        return this.bend;
    }

    public float getBendAxis() {
        return this.bendAxis;
    }

    @Deprecated
    public Matrix4f setRotationRad(float axisf, float value) {
        return this.applyBend(axisf, value);
    }

    @Deprecated
    public Matrix4f setRotationDeg(float axis, float val) {
        return this.applyBend(axis * 0.0174533f, val * 0.0174533f);
    }

    @Override
    public void render(PoseStack.Pose matrices, VertexConsumer vertexConsumer, float red, float green, float blue, float alpha, int light, int overlay) {
        for (Quad quad : this.sides) {
            quad.render(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
        }
    }

    @Override
    public void copyState(ICuboid other) {
        if (other instanceof BendableCuboid) {
            BendableCuboid b = (BendableCuboid)other;
            this.applyBend(b.bendAxis, b.bend);
        }
    }

    public Matrix4f getLastPosMatrix() {
        return new Matrix4f((Matrix4fc)this.lastPosMatrix);
    }

    @Override
    public boolean disableAfterDraw() {
        return false;
    }

    @Override
    public List<ModelPart.Polygon> getQuads() {
        ArrayList<ModelPart.Polygon> sides = new ArrayList<ModelPart.Polygon>();
        for (Quad quad : this.sides) {
            sides.add(quad.toModelPart_Quad());
        }
        return sides;
    }

    public static class Quad {
        public final IVertex[] vertices;
        final float u1;
        final float u2;
        final float v1;
        final float v2;
        final float su;
        final float sv;

        public Quad(RememberingPos[] vertices, float u1, float v1, float u2, float v2, float squishU, float squishV, boolean flip) {
            this.u1 = u1;
            this.u2 = u2;
            this.v1 = v1;
            this.v2 = v2;
            this.su = squishU;
            this.sv = squishV;
            float f = 0.0f / squishU;
            float g = 0.0f / squishV;
            this.vertices = new IVertex[4];
            this.vertices[0] = new RepositionableVertex(u2 / squishU - f, v1 / squishV + g, vertices[0]);
            this.vertices[1] = new RepositionableVertex(u1 / squishU + f, v1 / squishV + g, vertices[1]);
            this.vertices[2] = new RepositionableVertex(u1 / squishU + f, v2 / squishV - g, vertices[2]);
            this.vertices[3] = new RepositionableVertex(u2 / squishU - f, v2 / squishV - g, vertices[3]);
            if (flip) {
                int i = vertices.length;
                for (int j = 0; j < i / 2; ++j) {
                    IVertex vertex = this.vertices[j];
                    this.vertices[j] = this.vertices[i - 1 - j];
                    this.vertices[i - 1 - j] = vertex;
                }
            }
        }

        public void render(PoseStack.Pose matrices, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
            Vector3f direction = this.getDirection();
            direction.mul((Matrix3fc)matrices.m_252943_());
            for (int i = 0; i != 4; ++i) {
                IVertex vertex = this.vertices[i];
                Vector3f vertexPos = vertex.getPos();
                Vector4f pos = new Vector4f(vertexPos.x / 16.0f, vertexPos.y / 16.0f, vertexPos.z / 16.0f, 1.0f);
                pos.mul((Matrix4fc)matrices.m_252922_());
                vertexConsumer.m_5954_(pos.x, pos.y, pos.z, red, green, blue, alpha, vertex.getU(), vertex.getV(), overlay, light, direction.x, direction.y, direction.z);
            }
        }

        private Vector3f getDirection() {
            Vector3f buf = new Vector3f((Vector3fc)this.vertices[3].getPos());
            buf.mul(-1.0f);
            Vector3f vecB = new Vector3f((Vector3fc)this.vertices[1].getPos());
            vecB.add((Vector3fc)buf);
            buf = new Vector3f((Vector3fc)this.vertices[2].getPos());
            buf.mul(-1.0f);
            Vector3f vecA = new Vector3f((Vector3fc)this.vertices[0].getPos());
            vecA.add((Vector3fc)buf);
            vecA.cross((Vector3fc)vecB);
            return vecA.normalize().isFinite() ? vecA : Direction.NORTH.m_253071_();
        }

        private ModelPart.Polygon toModelPart_Quad() {
            ModelPart.Polygon quad = new ModelPart.Polygon(new ModelPart.Vertex[]{this.vertices[0].toMojVertex(), this.vertices[1].toMojVertex(), this.vertices[2].toMojVertex(), this.vertices[3].toMojVertex()}, this.u1, this.v1, this.u2, this.v2, this.su, this.sv, false, Direction.UP);
            ((DirectionMutator)quad).setDirection(this.getDirection());
            return quad;
        }
    }

    @FunctionalInterface
    public static interface BuildableBendable {
        public BendableCuboid build(Quad[] var1, RememberingPos[] var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, Direction var12, IBendable.Plane var13, IBendable.Plane var14, float var15);
    }

    public static class Builder
    implements ICuboidBuilder<BendableCuboid> {
        public Direction direction;

        public Builder setDirection(Direction d) {
            this.direction = d;
            return this;
        }

        public BendableCuboid build(ICuboidBuilder.Data data, BuildableBendable builder) {
            ArrayList<Quad> planes = new ArrayList<Quad>();
            HashMap<Vector3f, RememberingPos> positions = new HashMap<Vector3f, RememberingPos>();
            float minX = data.x;
            float minY = data.y;
            float minZ = data.z;
            float maxX = data.x + data.sizeX;
            float maxY = data.y + data.sizeY;
            float maxZ = data.z + data.sizeZ;
            float pminX = data.x - data.extraX;
            float pminY = data.y - data.extraY;
            float pminZ = data.z - data.extraZ;
            float pmaxX = maxX + data.extraX;
            float pmaxY = maxY + data.extraY;
            float pmaxZ = maxZ + data.extraZ;
            if (data.mirror) {
                float tmp = pminX;
                pminX = pmaxX;
                pmaxX = tmp;
            }
            Vector3f vertex1 = new Vector3f(pminX, pminY, pminZ);
            Vector3f vertex2 = new Vector3f(pmaxX, pminY, pminZ);
            Vector3f vertex3 = new Vector3f(pmaxX, pmaxY, pminZ);
            Vector3f vertex4 = new Vector3f(pminX, pmaxY, pminZ);
            Vector3f vertex5 = new Vector3f(pminX, pminY, pmaxZ);
            Vector3f vertex6 = new Vector3f(pmaxX, pminY, pmaxZ);
            Vector3f vertex7 = new Vector3f(pmaxX, pmaxY, pmaxZ);
            Vector3f vertex8 = new Vector3f(pminX, pmaxY, pmaxZ);
            int j = data.u;
            int k = (int)((float)data.u + data.sizeZ);
            int l = (int)((float)data.u + data.sizeZ + data.sizeX);
            int m = (int)((float)data.u + data.sizeZ + data.sizeX + data.sizeX);
            int n = (int)((float)data.u + data.sizeZ + data.sizeX + data.sizeZ);
            int o = (int)((float)data.u + data.sizeZ + data.sizeX + data.sizeZ + data.sizeX);
            int p = data.v;
            int q = (int)((float)data.v + data.sizeZ);
            int r = (int)((float)data.v + data.sizeZ + data.sizeY);
            this.createAndAddQuads(planes, positions, new Vector3f[]{vertex6, vertex5, vertex2}, k, p, l, q, data.textureWidth, data.textureHeight, data.mirror, data);
            this.createAndAddQuads(planes, positions, new Vector3f[]{vertex3, vertex4, vertex7}, l, q, m, p, data.textureWidth, data.textureHeight, data.mirror, data);
            this.createAndAddQuads(planes, positions, new Vector3f[]{vertex1, vertex5, vertex4}, j, q, k, r, data.textureWidth, data.textureHeight, data.mirror, data);
            this.createAndAddQuads(planes, positions, new Vector3f[]{vertex2, vertex1, vertex3}, k, q, l, r, data.textureWidth, data.textureHeight, data.mirror, data);
            this.createAndAddQuads(planes, positions, new Vector3f[]{vertex6, vertex2, vertex7}, l, q, n, r, data.textureWidth, data.textureHeight, data.mirror, data);
            this.createAndAddQuads(planes, positions, new Vector3f[]{vertex5, vertex6, vertex8}, n, q, o, r, data.textureWidth, data.textureHeight, data.mirror, data);
            IBendable.Plane aPlane = new IBendable.Plane(this.direction.m_253071_(), vertex7);
            IBendable.Plane bPlane = new IBendable.Plane(this.direction.m_253071_(), vertex1);
            boolean bl = this.direction == Direction.UP || this.direction == Direction.SOUTH || this.direction == Direction.EAST;
            float fullSize = -this.direction.m_253071_().dot((Vector3fc)vertex1) + this.direction.m_253071_().dot((Vector3fc)vertex7);
            float bendX = (data.sizeX + data.x + data.x) / 2.0f;
            float bendY = (data.sizeY + data.y + data.y) / 2.0f;
            float bendZ = (data.sizeZ + data.z + data.z) / 2.0f;
            return builder.build(planes.toArray(new Quad[0]), positions.values().toArray(new RememberingPos[0]), minX, minY, minZ, maxX, maxY, maxZ, bendX, bendY, bendZ, this.direction, bl ? aPlane : bPlane, bl ? bPlane : aPlane, fullSize);
        }

        @Override
        public BendableCuboid build(ICuboidBuilder.Data data) {
            return this.build(data, BendableCuboid::new);
        }

        private void createAndAddQuads(Collection<Quad> quads, HashMap<Vector3f, RememberingPos> positions, Vector3f[] edges, int u1, int v1, int u2, int v2, float squishU, float squishV, boolean flip, ICuboidBuilder.Data data) {
            int du = u2 < u1 ? 1 : -1;
            int dv = v1 < v2 ? 1 : -1;
            for (int localU = u2; localU != u1; localU += du) {
                for (int localV = v1; localV != v2; localV += dv) {
                    int localU2 = localU + du;
                    int localV2 = localV + dv;
                    RememberingPos rp0 = this.getOrCreate(positions, this.transformVector(new Vector3f((Vector3fc)edges[0]), new Vector3f((Vector3fc)edges[1]), new Vector3f((Vector3fc)edges[2]), u2, v1, u1, v2, localU2, localV));
                    RememberingPos rp1 = this.getOrCreate(positions, this.transformVector(new Vector3f((Vector3fc)edges[0]), new Vector3f((Vector3fc)edges[1]), new Vector3f((Vector3fc)edges[2]), u2, v1, u1, v2, localU2, localV2));
                    RememberingPos rp2 = this.getOrCreate(positions, this.transformVector(new Vector3f((Vector3fc)edges[0]), new Vector3f((Vector3fc)edges[1]), new Vector3f((Vector3fc)edges[2]), u2, v1, u1, v2, localU, localV2));
                    RememberingPos rp3 = this.getOrCreate(positions, this.transformVector(new Vector3f((Vector3fc)edges[0]), new Vector3f((Vector3fc)edges[1]), new Vector3f((Vector3fc)edges[2]), u2, v1, u1, v2, localU, localV));
                    quads.add(new Quad(new RememberingPos[]{rp3, rp0, rp1, rp2}, localU2, localV, localU, localV2, data.textureWidth, data.textureHeight, data.mirror));
                }
            }
        }

        Vector3f transformVector(Vector3f pos, Vector3f vectorU, Vector3f vectorV, int u1, int v1, int u2, int v2, int u, int v) {
            vectorU.sub((Vector3fc)pos);
            vectorU.mul(((float)u - (float)u1) / (float)(u2 - u1));
            vectorV.sub((Vector3fc)pos);
            vectorV.mul(((float)v - (float)v1) / (float)(v2 - v1));
            pos.add((Vector3fc)vectorU);
            pos.add((Vector3fc)vectorV);
            return pos;
        }

        RememberingPos getOrCreate(HashMap<Vector3f, RememberingPos> positions, Vector3f pos) {
            if (!positions.containsKey(pos)) {
                positions.put(pos, new RememberingPos(pos));
            }
            return positions.get(pos);
        }
    }
}

