/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.enginehub.worldeditcui.InitialisationFactory;
import org.enginehub.worldeditcui.config.Colour;
import org.enginehub.worldeditcui.render.ConfiguredColour;
import org.jetbrains.annotations.Nullable;

public final class CUIConfiguration
implements InitialisationFactory {
    private static final String CONFIG_FILE_NAME = "worldeditcui.config.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Colour.class, (Object)new TypeAdapter<Colour>(){

        public Colour read(JsonReader arg0) throws IOException {
            if (arg0.peek() == JsonToken.BEGIN_OBJECT) {
                arg0.beginObject();
                String colour = null;
                while (arg0.peek() == JsonToken.NAME) {
                    if (!arg0.nextName().equals("hex")) {
                        arg0.skipValue();
                        continue;
                    }
                    colour = arg0.nextString();
                }
                arg0.endObject();
                return colour == null ? null : Colour.parseRgba(colour);
            }
            if (arg0.peek() == JsonToken.NUMBER) {
                return new Colour(arg0.nextInt());
            }
            return Colour.parseRgba(arg0.nextString());
        }

        public void write(JsonWriter arg0, Colour arg1) throws IOException {
            arg0.value(arg1.hexString());
        }
    }.nullSafe()).create();
    private boolean debugMode = false;
    private boolean promiscuous = false;
    private boolean clearAllOnKey = false;
    private Colour cuboidGridColor = ConfiguredColour.CUBOIDGRID.getDefault();
    private Colour cuboidEdgeColor = ConfiguredColour.CUBOIDBOX.getDefault();
    private Colour cuboidFirstPointColor = ConfiguredColour.CUBOIDPOINT1.getDefault();
    private Colour cuboidSecondPointColor = ConfiguredColour.CUBOIDPOINT2.getDefault();
    private Colour polyGridColor = ConfiguredColour.POLYGRID.getDefault();
    private Colour polyEdgeColor = ConfiguredColour.POLYBOX.getDefault();
    private Colour polyPointColor = ConfiguredColour.POLYPOINT.getDefault();
    private Colour ellipsoidGridColor = ConfiguredColour.ELLIPSOIDGRID.getDefault();
    private Colour ellipsoidPointColor = ConfiguredColour.ELLIPSOIDCENTRE.getDefault();
    private Colour cylinderGridColor = ConfiguredColour.CYLINDERGRID.getDefault();
    private Colour cylinderEdgeColor = ConfiguredColour.CYLINDERBOX.getDefault();
    private Colour cylinderPointColor = ConfiguredColour.CYLINDERCENTRE.getDefault();
    private Colour chunkBoundaryColour = ConfiguredColour.CHUNKBOUNDARY.getDefault();
    private Colour chunkGridColour = ConfiguredColour.CHUNKGRID.getDefault();
    private static transient Map<String, Object> configArray = new LinkedHashMap<String, Object>();

    @Override
    public void initialise() {
        int index = 0;
        try {
            for (Field field : this.getClass().getDeclaredFields()) {
                if (field.getType() != Colour.class) continue;
                ConfiguredColour configuredColour = ConfiguredColour.values()[index++];
                Colour colour = Colour.firstOrDefault((Colour)field.get(this), configuredColour.getColour().hexString());
                field.set(this, colour);
                configuredColour.setColour(colour);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.save();
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public boolean isPromiscuous() {
        return this.promiscuous;
    }

    public void setPromiscuous(boolean promiscuous) {
        this.promiscuous = promiscuous;
    }

    public boolean isClearAllOnKey() {
        return this.clearAllOnKey;
    }

    public void setClearAllOnKey(boolean clearAllOnKey) {
        this.clearAllOnKey = clearAllOnKey;
    }

    private static Path getConfigFile() {
        return Minecraft.m_91087_().f_91069_.toPath().resolve("config").resolve(CONFIG_FILE_NAME);
    }

    public static CUIConfiguration create() {
        Path jsonFile = CUIConfiguration.getConfigFile();
        CUIConfiguration config = null;
        if (Files.exists(jsonFile, new LinkOption[0])) {
            try (BufferedReader fileReader = Files.newBufferedReader(jsonFile, StandardCharsets.UTF_8);){
                config = (CUIConfiguration)GSON.fromJson((Reader)fileReader, CUIConfiguration.class);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (config == null) {
            config = new CUIConfiguration();
        }
        configArray.put("debugMode", config.debugMode);
        configArray.put("promiscuous", config.promiscuous);
        configArray.put("clearAllOnKey", config.clearAllOnKey);
        configArray.put("cuboidGridColor", config.cuboidGridColor);
        configArray.put("cuboidEdgeColor", config.cuboidEdgeColor);
        configArray.put("cuboidFirstPointColor", config.cuboidFirstPointColor);
        configArray.put("cuboidSecondPointColor", config.cuboidSecondPointColor);
        configArray.put("polyGridColor", config.polyGridColor);
        configArray.put("polyEdgeColor", config.polyEdgeColor);
        configArray.put("polyPointColor", config.polyPointColor);
        configArray.put("ellipsoidGridColor", config.ellipsoidGridColor);
        configArray.put("ellipsoidPointColor", config.ellipsoidPointColor);
        configArray.put("cylinderGridColor", config.cylinderGridColor);
        configArray.put("cylinderEdgeColor", config.cylinderEdgeColor);
        configArray.put("cylinderPointColor", config.cylinderPointColor);
        configArray.put("chunkBoundaryColour", config.chunkBoundaryColour);
        configArray.put("chunkGridColour", config.chunkGridColour);
        return config;
    }

    public void changeValue(String text, Object value) {
        if (value == null) {
            configArray.replace(text, this.getDefaultValue(text));
        } else {
            configArray.replace(text, value);
        }
    }

    public Map<String, Object> getConfigArray() {
        return configArray;
    }

    public void configChanged() {
        this.debugMode = (Boolean)configArray.get("debugMode");
        this.promiscuous = (Boolean)configArray.get("promiscuous");
        this.clearAllOnKey = (Boolean)configArray.get("clearAllOnKey");
        this.cuboidGridColor = (Colour)configArray.get("cuboidGridColor");
        this.cuboidEdgeColor = (Colour)configArray.get("cuboidEdgeColor");
        this.cuboidFirstPointColor = (Colour)configArray.get("cuboidFirstPointColor");
        this.cuboidSecondPointColor = (Colour)configArray.get("cuboidSecondPointColor");
        this.polyGridColor = (Colour)configArray.get("polyGridColor");
        this.polyEdgeColor = (Colour)configArray.get("polyEdgeColor");
        this.polyPointColor = (Colour)configArray.get("polyPointColor");
        this.ellipsoidGridColor = (Colour)configArray.get("ellipsoidGridColor");
        this.ellipsoidPointColor = (Colour)configArray.get("ellipsoidPointColor");
        this.cylinderGridColor = (Colour)configArray.get("cylinderGridColor");
        this.cylinderEdgeColor = (Colour)configArray.get("cylinderEdgeColor");
        this.cylinderPointColor = (Colour)configArray.get("cylinderPointColor");
        this.chunkBoundaryColour = (Colour)configArray.get("chunkBoundaryColour");
        this.chunkGridColour = (Colour)configArray.get("chunkGridColour");
        this.initialise();
    }

    public Object getDefaultValue(String text) {
        return switch (text) {
            case "debugMode", "promiscuous", "clearAllOnKey" -> false;
            case "cuboidGridColor" -> ConfiguredColour.CUBOIDGRID.getDefault();
            case "cuboidEdgeColor" -> ConfiguredColour.CUBOIDBOX.getDefault();
            case "cuboidFirstPointColor" -> ConfiguredColour.CUBOIDPOINT1.getDefault();
            case "cuboidSecondPointColor" -> ConfiguredColour.CUBOIDPOINT2.getDefault();
            case "polyGridColor" -> ConfiguredColour.POLYGRID.getDefault();
            case "polyEdgeColor" -> ConfiguredColour.POLYBOX.getDefault();
            case "polyPointColor" -> ConfiguredColour.POLYPOINT.getDefault();
            case "ellipsoidGridColor" -> ConfiguredColour.ELLIPSOIDGRID.getDefault();
            case "ellipsoidPointColor" -> ConfiguredColour.ELLIPSOIDCENTRE.getDefault();
            case "cylinderGridColor" -> ConfiguredColour.CYLINDERGRID.getDefault();
            case "cylinderEdgeColor" -> ConfiguredColour.CYLINDERBOX.getDefault();
            case "cylinderPointColor" -> ConfiguredColour.CYLINDERCENTRE.getDefault();
            case "chunkBoundaryColour" -> ConfiguredColour.CHUNKBOUNDARY.getDefault();
            case "chunkGridColour" -> ConfiguredColour.CHUNKGRID.getDefault();
            default -> null;
        };
    }

    @Nullable
    public Component getTooltip(String text) {
        String key = this.getKey(text);
        if (key == null) {
            return null;
        }
        if (text.equals("clearAllOnKey")) {
            return Component.m_237110_((String)(key + ".tooltip"), (Object[])new Object[]{Component.m_237115_((String)"key.worldeditcui.clear"), Component.m_237117_((String)"key.worldeditcui.clear").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)))});
        }
        return Component.m_237115_((String)(key + ".tooltip"));
    }

    @Nullable
    public Component getDescription(String text) {
        String key = this.getKey(text);
        if (key == null) {
            return null;
        }
        return Component.m_237115_((String)key);
    }

    @Nullable
    private String getKey(String text) {
        return switch (text) {
            case "debugMode" -> "worldeditcui.options.debugMode";
            case "promiscuous" -> "worldeditcui.options.compat.spammy";
            case "clearAllOnKey" -> "worldeditcui.options.extra.clearall";
            case "cuboidGridColor" -> "worldeditcui.color.cuboidgrid";
            case "cuboidEdgeColor" -> "worldeditcui.color.cuboidedge";
            case "cuboidFirstPointColor" -> "worldeditcui.color.cuboidpoint1";
            case "cuboidSecondPointColor" -> "worldeditcui.color.cuboidpoint2";
            case "polyGridColor" -> "worldeditcui.color.polygrid";
            case "polyEdgeColor" -> "worldeditcui.color.polyedge";
            case "polyPointColor" -> "worldeditcui.color.polypoint";
            case "ellipsoidGridColor" -> "worldeditcui.color.ellipsoidgrid";
            case "ellipsoidPointColor" -> "worldeditcui.color.ellipsoidpoint";
            case "cylinderGridColor" -> "worldeditcui.color.cylindergrid";
            case "cylinderEdgeColor" -> "worldeditcui.color.cylinderedge";
            case "cylinderPointColor" -> "worldeditcui.color.cylinderpoint";
            case "chunkBoundaryColour" -> "worldeditcui.color.chunkboundary";
            case "chunkGridColour" -> "worldeditcui.color.chunkgrid";
            default -> null;
        };
    }

    public void save() {
        try (BufferedWriter fileWriter = Files.newBufferedWriter(CUIConfiguration.getConfigFile(), StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson((Object)this, (Appendable)fileWriter);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

