/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.warbornrenewed.sound;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import ru.liko.warbornrenewed.content.armorset.WarbornArmorItem;
import ru.liko.warbornrenewed.registry.ModSoundEvents;

public final class WarbornSoundPlayer {
    private static final float DEFAULT_VOLUME = 1.0f;

    private WarbornSoundPlayer() {
    }

    public static void playArmorEquip(Player player, EquipmentSlot slot) {
        SoundEvent sound = slot == EquipmentSlot.HEAD ? (SoundEvent)ModSoundEvents.ARMOR_HELMET_EQUIP.get() : (SoundEvent)ModSoundEvents.ARMOR_BODY_EQUIP.get();
        WarbornSoundPlayer.play(player, sound, 1.0f);
    }

    public static void playArmorUnequip(Player player, EquipmentSlot slot) {
        SoundEvent sound = slot == EquipmentSlot.HEAD ? (SoundEvent)ModSoundEvents.ARMOR_HELMET_UNEQUIP.get() : (SoundEvent)ModSoundEvents.ARMOR_BODY_UNEQUIP.get();
        WarbornSoundPlayer.play(player, sound, 1.0f);
    }

    public static void playVisionToggle(Player player, ItemStack helmetStack, boolean activated) {
        boolean thermalOnly;
        Item item = helmetStack.m_41720_();
        if (!(item instanceof WarbornArmorItem)) {
            return;
        }
        WarbornArmorItem armorItem = (WarbornArmorItem)item;
        boolean bl = thermalOnly = armorItem.hasVisionCapability("thermal") && !armorItem.hasVisionCapability("nvg");
        SoundEvent sound = thermalOnly ? (activated ? (SoundEvent)ModSoundEvents.VISION_THERMAL_ENABLE.get() : (SoundEvent)ModSoundEvents.VISION_THERMAL_DISABLE.get()) : (activated ? (SoundEvent)ModSoundEvents.VISION_NVG_ENABLE.get() : (SoundEvent)ModSoundEvents.VISION_NVG_DISABLE.get());
        WarbornSoundPlayer.play(player, sound, activated ? 0.95f : 1.05f);
    }

    private static void play(Player player, SoundEvent sound, float pitch) {
        if (sound == null) {
            return;
        }
        if (player.m_9236_().m_5776_()) {
            player.m_5496_(sound, 1.0f, pitch);
        } else {
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_(), sound, SoundSource.PLAYERS, 1.0f, pitch);
        }
    }
}

