/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.warbornrenewed.sound;

import java.util.Objects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ru.liko.warbornrenewed.content.armorset.WarbornArmorItem;
import ru.liko.warbornrenewed.sound.WarbornSoundPlayer;

@Mod.EventBusSubscriber(modid="warbornrenewed")
public final class WarbornSoundHandler {
    private WarbornSoundHandler() {
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        ItemStack current;
        boolean same;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (player.f_19797_ < 20) {
            return;
        }
        EquipmentSlot slot = event.getSlot();
        if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) {
            return;
        }
        ItemStack previous = event.getFrom();
        boolean bl = same = ItemStack.m_41656_((ItemStack)previous, (ItemStack)(current = event.getTo())) && Objects.equals(previous.m_41783_(), current.m_41783_());
        if (!same && WarbornSoundHandler.isWarbornArmor(previous)) {
            WarbornSoundPlayer.playArmorUnequip(player, slot);
        }
        if (!same && WarbornSoundHandler.isWarbornArmor(current)) {
            WarbornSoundPlayer.playArmorEquip(player, slot);
        }
    }

    private static boolean isWarbornArmor(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_() instanceof WarbornArmorItem;
    }
}

