/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.warbornrenewed.registry;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModAttributes {
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"warbornrenewed");
    public static final RegistryObject<Attribute> BULLET_RESISTANCE = ATTRIBUTES.register("bullet_resistance", () -> new RangedAttribute("attribute.warbornrenewed.bullet_resistance", 0.0, 0.0, 1.0).m_22084_(true));
    public static final RegistryObject<Attribute> PROTECTION_CLASS = ATTRIBUTES.register("protection_class", () -> new RangedAttribute("attribute.warbornrenewed.protection_class", 0.0, 0.0, 6.0).m_22084_(true));
    public static final RegistryObject<Attribute> EFFECTIVE_THICKNESS = ATTRIBUTES.register("effective_thickness", () -> new RangedAttribute("attribute.warbornrenewed.effective_thickness", 0.0, 0.0, 100.0).m_22084_(true));
    public static final RegistryObject<Attribute> BLAST_DAMAGE_MULTIPLIER = ATTRIBUTES.register("blast_damage_multiplier", () -> new RangedAttribute("attribute.warbornrenewed.blast_damage_multiplier", 1.0, 0.0, 2.0).m_22084_(true));
    public static final RegistryObject<Attribute> ARMOR_MOVEMENT_SPEED = ATTRIBUTES.register("armor_movement_speed", () -> new RangedAttribute("attribute.warbornrenewed.armor_movement_speed", 0.0, -0.5, 0.2).m_22084_(true));

    public static void register(IEventBus eventBus) {
        ATTRIBUTES.register(eventBus);
    }

    public static double getBulletResistance(LivingEntity livingEntity) {
        return livingEntity.m_21133_((Attribute)BULLET_RESISTANCE.get());
    }

    public static int getProtectionClass(LivingEntity livingEntity) {
        return (int)livingEntity.m_21133_((Attribute)PROTECTION_CLASS.get());
    }

    public static double getEffectiveThickness(LivingEntity livingEntity) {
        return livingEntity.m_21133_((Attribute)EFFECTIVE_THICKNESS.get());
    }

    public static boolean isPenetrated(int protectionClass, double bulletEnergy) {
        double[] energyThresholds = new double[]{0.0, 600.0, 800.0, 1000.0, 3500.0, 5000.0, 8000.0};
        if (protectionClass < 0 || protectionClass >= energyThresholds.length) {
            return true;
        }
        return bulletEnergy > energyThresholds[protectionClass];
    }

    public static double calculateDamage(double initialDamage, double bulletResistance, boolean isPenetrated) {
        if (!isPenetrated) {
            return initialDamage * (1.0 - bulletResistance);
        }
        double damageReduction = bulletResistance * 0.5;
        return initialDamage * (1.0 - damageReduction);
    }
}

