/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.warbornrenewed.registry;

import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public enum ModArmorMaterials implements ArmorMaterial
{
    LEATHER("leather", 5, new int[]{1, 1, 1, 1}, 0, SoundEvents.f_11678_, 0.1f, 0.0f, () -> Ingredient.f_43901_),
    KEVLAR("kevlar", 20, new int[]{1, 3, 5, 2}, 15, SoundEvents.f_11678_, 0.5f, 0.0f, () -> Ingredient.f_43901_),
    CERAMIC("ceramic", 30, new int[]{2, 5, 7, 3}, 12, SoundEvents.f_11677_, 2.5f, 0.05f, () -> Ingredient.f_43901_),
    AR500_STEEL("ar500_steel", 40, new int[]{2, 4, 6, 2}, 10, SoundEvents.f_11677_, 2.0f, 0.1f, () -> Ingredient.f_43901_),
    UHMWPE("uhmwpe", 45, new int[]{3, 6, 8, 3}, 18, SoundEvents.f_11679_, 3.0f, 0.08f, () -> Ingredient.f_43901_),
    COMPOSITE("composite", 55, new int[]{3, 7, 9, 4}, 15, SoundEvents.f_11679_, 4.0f, 0.15f, () -> Ingredient.f_43901_),
    TITANIUM("titanium", 60, new int[]{4, 7, 9, 4}, 20, SoundEvents.f_11679_, 4.5f, 0.2f, () -> Ingredient.f_43901_);

    private static final int[] DURABILITY_PER_SLOT;
    private final String name;
    private final int durabilityMultiplier;
    private final int[] protectionPerSlot;
    private final int enchantability;
    private final SoundEvent equipSound;
    private final float toughness;
    private final float knockbackResistance;
    private final Supplier<Ingredient> repairIngredient;

    private ModArmorMaterials(String name, int durabilityMultiplier, int[] protectionPerSlot, int enchantability, SoundEvent equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.protectionPerSlot = protectionPerSlot;
        this.enchantability = enchantability;
        this.equipSound = equipSound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = repairIngredient;
    }

    public int m_266425_(@NotNull ArmorItem.Type type) {
        return DURABILITY_PER_SLOT[type.ordinal()] * this.durabilityMultiplier;
    }

    public int m_7366_(@NotNull ArmorItem.Type type) {
        return this.protectionPerSlot[type.ordinal()];
    }

    public int m_6646_() {
        return this.enchantability;
    }

    @NotNull
    public SoundEvent m_7344_() {
        return this.equipSound;
    }

    @NotNull
    public Ingredient m_6230_() {
        return this.repairIngredient.get();
    }

    @NotNull
    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        DURABILITY_PER_SLOT = new int[]{13, 15, 16, 11};
    }
}

