/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.warbornrenewed.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import ru.liko.warbornrenewed.content.armorset.WarbornArmorItem;
import ru.liko.warbornrenewed.sound.WarbornSoundPlayer;

public class NVGTogglePacket {
    private final boolean nvgDown;

    public NVGTogglePacket(boolean nvgDown) {
        this.nvgDown = nvgDown;
    }

    public NVGTogglePacket(FriendlyByteBuf buf) {
        this.nvgDown = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.nvgDown);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Item patt1336$temp;
            ItemStack helmet;
            ServerPlayer player = context.getSender();
            if (player != null && !(helmet = player.m_150109_().m_36052_(3)).m_41619_() && (patt1336$temp = helmet.m_41720_()) instanceof WarbornArmorItem) {
                WarbornArmorItem armorItem = (WarbornArmorItem)patt1336$temp;
                boolean supportsNVG = armorItem.hasVisionCapability("nvg");
                boolean supportsThermal = armorItem.hasVisionCapability("thermal");
                if (supportsNVG || supportsThermal) {
                    WarbornArmorItem.setNVGDown(helmet, this.nvgDown);
                    WarbornSoundPlayer.playVisionToggle((Player)player, helmet, this.nvgDown);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

