/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.warbornrenewed.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import ru.liko.warbornrenewed.client.shader.VisionShaderManager;
import ru.liko.warbornrenewed.content.armorset.WarbornArmorItem;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={LivingEntityRenderer.class})
public abstract class LivingEntityRendererMixin<T extends LivingEntity, M extends EntityModel<T>>
extends EntityRenderer<T>
implements RenderLayerParent<T, M> {
    private static final int FULL_BRIGHT_LIGHT = 0xF000F0;

    protected LivingEntityRendererMixin(EntityRendererProvider.Context context) {
        super(context);
    }

    @ModifyVariable(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at=@At(value="HEAD"), argsOnly=true)
    private int warbornrenewed$forceFullBright(int packedLight, T entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource) {
        if (this.warbornrenewed$isThermalVisionActive()) {
            return 0xF000F0;
        }
        return packedLight;
    }

    @Unique
    private boolean warbornrenewed$isThermalVisionActive() {
        Item item;
        if (!VisionShaderManager.isThermalShaderActive()) {
            return false;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft == null || minecraft.f_91074_ == null) {
            return false;
        }
        ItemStack helmet = minecraft.f_91074_.m_6844_(EquipmentSlot.HEAD);
        if (helmet.m_41619_() || !((item = helmet.m_41720_()) instanceof WarbornArmorItem)) {
            return false;
        }
        WarbornArmorItem armorItem = (WarbornArmorItem)item;
        if (!armorItem.hasVisionCapability("thermal")) {
            return false;
        }
        return !WarbornArmorItem.isHelmetOpen(helmet);
    }
}

