/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.warbornrenewed.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ru.liko.warbornrenewed.client.shader.VisionShaderManager;
import ru.liko.warbornrenewed.client.shader.VisionShaderRegistry;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={GameRenderer.class})
public class GameRendererMixin {
    @Shadow
    @Final
    private Minecraft f_109059_;
    @Shadow
    private PostChain f_109050_;

    @Inject(method={"renderLevel"}, at={@At(value="TAIL")})
    private void warbornrenewed$applyVisionShader(float partialTick, long nanoTime, PoseStack poseStack, CallbackInfo ci) {
        if (this.f_109059_.f_91073_ != null && this.f_109059_.f_91074_ != null) {
            VisionShaderManager.processShaders(this.f_109059_);
        }
    }

    @Inject(method={"checkEntityPostEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void warbornrenewed$keepVisionShader(Entity entity, CallbackInfo ci) {
        if (this.warbornrenewed$isVisionPostEffectActive() && this.warbornrenewed$isWarbornEffect(this.f_109050_)) {
            ci.cancel();
        }
    }

    @Inject(method={"shutdownEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void warbornrenewed$preventExternalShutdown(CallbackInfo ci) {
        if (this.warbornrenewed$isVisionPostEffectActive() && !VisionShaderRegistry.getInstance().isInternalShutdownInProgress() && this.warbornrenewed$isWarbornEffect(this.f_109050_)) {
            ci.cancel();
        }
    }

    @Unique
    private boolean warbornrenewed$isVisionPostEffectActive() {
        return VisionShaderRegistry.getInstance().isShaderActive();
    }

    @Unique
    private boolean warbornrenewed$isWarbornEffect(PostChain effect) {
        if (effect == null) {
            return false;
        }
        String effectName = effect.m_110022_();
        if (effectName == null) {
            return false;
        }
        return effectName.contains("warbornrenewed");
    }
}

