/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.warbornrenewed.content.armorset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import ru.liko.warbornrenewed.content.armorset.ArmorAttributeSpec;
import ru.liko.warbornrenewed.content.armorset.ArmorBonesSpec;
import ru.liko.warbornrenewed.content.armorset.ArmorVisualSpec;
import ru.liko.warbornrenewed.content.armorset.WarbornArmorItem;
import ru.liko.warbornrenewed.registry.ModItems;

public final class WarbornArmorSet {
    private final String id;
    private final EnumMap<ArmorItem.Type, List<RegistryObject<WarbornArmorItem>>> piecesByType;
    private final List<RegistryObject<WarbornArmorItem>> allPieces;

    private WarbornArmorSet(String id, EnumMap<ArmorItem.Type, List<RegistryObject<WarbornArmorItem>>> piecesByType, List<RegistryObject<WarbornArmorItem>> allPieces) {
        this.id = id;
        EnumMap byTypeCopy = new EnumMap(ArmorItem.Type.class);
        piecesByType.forEach((type, list) -> byTypeCopy.put((ArmorItem.Type)type, List.copyOf(list)));
        this.piecesByType = byTypeCopy;
        this.allPieces = List.copyOf(allPieces);
    }

    public String id() {
        return this.id;
    }

    public Collection<RegistryObject<WarbornArmorItem>> pieces() {
        return this.allPieces;
    }

    public Optional<RegistryObject<WarbornArmorItem>> piece(ArmorItem.Type type) {
        return Optional.ofNullable(this.piecesByType.get(type)).flatMap(list -> list.stream().findFirst());
    }

    public List<RegistryObject<WarbornArmorItem>> pieces(ArmorItem.Type type) {
        List<RegistryObject<WarbornArmorItem>> list = this.piecesByType.get(type);
        return list == null ? List.of() : list;
    }

    static WarbornArmorSet register(DeferredRegister<Item> items, Builder builder) {
        EnumMap<ArmorItem.Type, List<RegistryObject<WarbornArmorItem>>> registrations = new EnumMap<ArmorItem.Type, List<RegistryObject<WarbornArmorItem>>>(ArmorItem.Type.class);
        ArrayList<RegistryObject<WarbornArmorItem>> all = new ArrayList<RegistryObject<WarbornArmorItem>>();
        builder.definitions.forEach((type, definitions) -> {
            List entries = registrations.computeIfAbsent((ArmorItem.Type)type, key -> new ArrayList());
            for (ArmorPieceDefinition definition : definitions) {
                RegistryObject entry = items.register(definition.registryName(), () -> definition.create((ArmorItem.Type)type));
                entries.add(entry);
                all.add(entry);
                ModItems.trackArmorPiece((RegistryObject<? extends Item>)entry);
            }
        });
        return new WarbornArmorSet(builder.id, registrations, all);
    }

    public static Builder builder(String id) {
        return new Builder(id);
    }

    public static final class Builder {
        private final String id;
        private final Map<ArmorItem.Type, List<ArmorPieceDefinition>> definitions = new EnumMap<ArmorItem.Type, List<ArmorPieceDefinition>>(ArmorItem.Type.class);
        private final Map<ArmorItem.Type, Integer> typeCounts = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        private ArmorPieceDefinition defaults;

        private Builder(String id) {
            this.id = Objects.requireNonNull(id, "id");
        }

        public Builder defaultMaterial(ArmorPieceDefinition.MaterialProvider material) {
            this.defaults = this.ensureDefaults().withMaterial(material);
            return this;
        }

        public Builder defaultVisuals(Consumer<ArmorVisualSpec.Builder> visuals) {
            ArmorVisualSpec.Builder builder = ArmorVisualSpec.builder();
            visuals.accept(builder);
            this.defaults = this.ensureDefaults().withVisuals(builder.build());
            return this;
        }

        public Builder defaultBones(UnaryOperator<ArmorBonesSpec.Builder> operator) {
            ArmorBonesSpec.Builder bonesBuilder = (ArmorBonesSpec.Builder)operator.apply(ArmorBonesSpec.builder());
            this.defaults = this.ensureDefaults().withBones(bonesBuilder.build());
            return this;
        }

        public Builder helmet(Consumer<ArmorPieceBuilder> consumer) {
            return this.piece(ArmorItem.Type.HELMET, consumer);
        }

        public Builder chestplate(Consumer<ArmorPieceBuilder> consumer) {
            return this.piece(ArmorItem.Type.CHESTPLATE, consumer);
        }

        public Builder leggings(Consumer<ArmorPieceBuilder> consumer) {
            return this.piece(ArmorItem.Type.LEGGINGS, consumer);
        }

        public Builder boots(Consumer<ArmorPieceBuilder> consumer) {
            return this.piece(ArmorItem.Type.BOOTS, consumer);
        }

        public WarbornArmorSet register(DeferredRegister<Item> items) {
            int totalPieces = this.definitions.values().stream().mapToInt(List::size).sum();
            if (totalPieces == 0) {
                throw new IllegalStateException("No armor pieces configured for set " + this.id);
            }
            this.definitions.values().stream().flatMap(Collection::stream).forEach(definition -> definition.validate(this.id));
            return WarbornArmorSet.register(items, this);
        }

        private Builder piece(ArmorItem.Type type, Consumer<ArmorPieceBuilder> consumer) {
            int sequenceIndex = this.typeCounts.compute(type, (key, count) -> count == null ? 1 : count + 1) - 1;
            ArmorPieceBuilder builder = new ArmorPieceBuilder(this.id, type, this.defaults, sequenceIndex);
            consumer.accept(builder);
            ArmorPieceDefinition definition = builder.build();
            this.definitions.computeIfAbsent(type, key -> new ArrayList()).add(definition);
            return this;
        }

        private ArmorPieceDefinition ensureDefaults() {
            if (this.defaults == null) {
                this.defaults = ArmorPieceDefinition.defaults();
            }
            return this.defaults;
        }
    }

    static final class ArmorPieceDefinition {
        private final String registryName;
        private final MaterialProvider materialProvider;
        private final ArmorVisualSpec visuals;
        private final ArmorBonesSpec bones;
        private final PropertiesProvider propertiesProvider;
        private final List<ArmorAttributeSpec> attributes;
        private final List<String> visionCapabilities;

        ArmorPieceDefinition(String registryName, MaterialProvider materialProvider, ArmorVisualSpec visuals, ArmorBonesSpec bones, PropertiesProvider propertiesProvider, List<ArmorAttributeSpec> attributes, List<String> visionCapabilities) {
            this.registryName = registryName;
            this.materialProvider = materialProvider;
            this.visuals = visuals;
            this.bones = bones;
            this.propertiesProvider = propertiesProvider;
            this.attributes = attributes;
            this.visionCapabilities = visionCapabilities;
        }

        static ArmorPieceDefinition defaults() {
            return new ArmorPieceDefinition(null, null, null, null, PropertiesProvider.identity(), List.of(), List.of());
        }

        ArmorPieceDefinition withMaterial(MaterialProvider material) {
            return new ArmorPieceDefinition(this.registryName, material, this.visuals, this.bones, this.propertiesProvider, this.attributes, this.visionCapabilities);
        }

        ArmorPieceDefinition withVisuals(ArmorVisualSpec visuals) {
            return new ArmorPieceDefinition(this.registryName, this.materialProvider, visuals, this.bones, this.propertiesProvider, this.attributes, this.visionCapabilities);
        }

        ArmorPieceDefinition withBones(ArmorBonesSpec bones) {
            return new ArmorPieceDefinition(this.registryName, this.materialProvider, this.visuals, bones, this.propertiesProvider, this.attributes, this.visionCapabilities);
        }

        ArmorPieceDefinition withProperties(PropertiesProvider propertiesProvider) {
            return new ArmorPieceDefinition(this.registryName, this.materialProvider, this.visuals, this.bones, propertiesProvider, this.attributes, this.visionCapabilities);
        }

        ArmorPieceDefinition withRegistryName(String registryName) {
            return new ArmorPieceDefinition(registryName, this.materialProvider, this.visuals, this.bones, this.propertiesProvider, this.attributes, this.visionCapabilities);
        }

        ArmorPieceDefinition withAttributes(List<ArmorAttributeSpec> attributes) {
            return new ArmorPieceDefinition(this.registryName, this.materialProvider, this.visuals, this.bones, this.propertiesProvider, List.copyOf(attributes), this.visionCapabilities);
        }

        ArmorPieceDefinition withVisionCapabilities(List<String> visionCapabilities) {
            return new ArmorPieceDefinition(this.registryName, this.materialProvider, this.visuals, this.bones, this.propertiesProvider, this.attributes, List.copyOf(visionCapabilities));
        }

        void validate(String setId) {
            if (this.visuals == null) {
                throw new IllegalStateException("Visuals are not set for armor piece in set " + setId);
            }
        }

        String registryName() {
            if (this.registryName == null) {
                throw new IllegalStateException("Registry name must be provided");
            }
            return this.registryName;
        }

        WarbornArmorItem create(ArmorItem.Type type) {
            String name = this.registryName();
            WarbornArmorItem item = new WarbornArmorItem(name, this.materialProvider.material(type), type, this.propertiesProvider.properties(type), this.visuals, this.bones != null ? this.bones : ArmorBonesSpec.defaults(type), this.attributes);
            if (type == ArmorItem.Type.HELMET) {
                for (String capability : this.visionCapabilities) {
                    item.addVisionCapability(capability);
                }
            }
            return item;
        }

        public static interface MaterialProvider {
            public ArmorMaterial material(ArmorItem.Type var1);
        }

        public static interface PropertiesProvider {
            public Item.Properties properties(ArmorItem.Type var1);

            public static PropertiesProvider identity() {
                return type -> new Item.Properties().m_41487_(1);
            }
        }
    }

    public static final class ArmorPieceBuilder {
        private final String setId;
        private final ArmorItem.Type type;
        private final int sequenceIndex;
        private final List<ArmorAttributeSpec> attributes = new ArrayList<ArmorAttributeSpec>();
        private final List<String> visionCapabilities = new ArrayList<String>();
        private ArmorPieceDefinition.MaterialProvider materialProvider;
        private ArmorVisualSpec visuals;
        private ArmorBonesSpec bones;
        private ArmorPieceDefinition.PropertiesProvider propertiesProvider;
        private String registryName;

        private ArmorPieceBuilder(String setId, ArmorItem.Type type, ArmorPieceDefinition defaults, int sequenceIndex) {
            this.setId = setId;
            this.type = type;
            this.sequenceIndex = sequenceIndex;
            if (defaults != null) {
                this.materialProvider = defaults.materialProvider;
                this.visuals = defaults.visuals;
                this.bones = defaults.bones;
                this.propertiesProvider = defaults.propertiesProvider;
                this.registryName = defaults.registryName;
                this.attributes.addAll(defaults.attributes);
                this.visionCapabilities.addAll(defaults.visionCapabilities);
            }
        }

        public ArmorPieceBuilder registryName(String registryName) {
            this.registryName = registryName;
            return this;
        }

        public ArmorPieceBuilder material(ArmorPieceDefinition.MaterialProvider materialProvider) {
            this.materialProvider = materialProvider;
            return this;
        }

        public ArmorPieceBuilder visuals(Consumer<ArmorVisualSpec.Builder> consumer) {
            ArmorVisualSpec.Builder builder = ArmorVisualSpec.builder();
            consumer.accept(builder);
            this.visuals = builder.build();
            return this;
        }

        public ArmorPieceBuilder bones(UnaryOperator<ArmorBonesSpec.Builder> operator) {
            ArmorBonesSpec.Builder builder = (ArmorBonesSpec.Builder)operator.apply(ArmorBonesSpec.builder());
            this.bones = builder.build();
            return this;
        }

        public ArmorPieceBuilder properties(UnaryOperator<Item.Properties> operator) {
            this.propertiesProvider = type1 -> {
                Item.Properties base = new Item.Properties().m_41487_(1);
                return (Item.Properties)operator.apply(base);
            };
            return this;
        }

        public ArmorPieceBuilder attribute(ArmorAttributeSpec attribute) {
            this.attributes.add(attribute);
            return this;
        }

        public ArmorPieceBuilder bulletResistance(double value) {
            return this.bulletResistance(value, true);
        }

        public ArmorPieceBuilder bulletResistance(double value, boolean scaleWithDurability) {
            this.attributes.add(ArmorAttributeSpec.bulletResistance(value, scaleWithDurability));
            return this;
        }

        public ArmorPieceBuilder withNVG() {
            if (this.type == ArmorItem.Type.HELMET) {
                this.visionCapabilities.add("nvg");
            }
            return this;
        }

        public ArmorPieceBuilder withThermal() {
            if (this.type == ArmorItem.Type.HELMET) {
                this.visionCapabilities.add("thermal");
            }
            return this;
        }

        private ArmorPieceDefinition build() {
            if (this.materialProvider == null) {
                throw new IllegalStateException("Material is required for armor piece " + this.setId + " - " + String.valueOf(this.type));
            }
            if (this.visuals == null) {
                throw new IllegalStateException("Visuals are required for armor piece " + this.setId + " - " + String.valueOf(this.type));
            }
            ArmorPieceDefinition.PropertiesProvider properties = this.propertiesProvider != null ? this.propertiesProvider : ArmorPieceDefinition.PropertiesProvider.identity();
            ArmorBonesSpec boneSpec = this.bones != null ? this.bones : ArmorBonesSpec.defaults(this.type);
            String registry = this.registryName != null ? this.registryName : this.defaultName();
            return new ArmorPieceDefinition(registry, this.materialProvider, this.visuals, boneSpec, properties, this.attributes, this.visionCapabilities);
        }

        private String defaultName() {
            String suffix = this.type.name().toLowerCase(Locale.ROOT);
            if (this.sequenceIndex <= 0) {
                return this.setId + "_" + suffix;
            }
            return this.setId + "_" + suffix + "_" + (this.sequenceIndex + 1);
        }
    }
}

