/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.warbornrenewed.content.armorset;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;
import ru.liko.warbornrenewed.content.armorset.ArmorAttributeSpec;
import ru.liko.warbornrenewed.content.armorset.ArmorBonesSpec;
import ru.liko.warbornrenewed.content.armorset.ArmorVisualSpec;
import ru.liko.warbornrenewed.content.armorset.WarbornArmorRenderer;
import ru.liko.warbornrenewed.registry.ModAttributes;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WarbornArmorItem
extends ArmorItem
implements GeoItem {
    public static final String TAG_NVG = "nvg";
    public static final String TAG_THERMAL = "thermal";
    public static final String TAG_DIGITAL = "digital";
    public static final String TAG_SIMPLE_NVG = "simple_nvg";
    public static final String TAG_GOGGLE = "goggle";
    public static final String NBT_NVG_DOWN = "nvg_down";
    public static final String NBT_HELMET_OPEN = "helmet_top_open";
    private final String itemId;
    private final ArmorVisualSpec visuals;
    private final ArmorBonesSpec bones;
    private final List<ArmorAttributeSpec> attributes;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final List<String> visionCapabilities = new ArrayList<String>();

    public WarbornArmorItem(String itemId, ArmorMaterial material, ArmorItem.Type type, Item.Properties properties, ArmorVisualSpec visuals, ArmorBonesSpec bones, List<ArmorAttributeSpec> attributes) {
        super(material, type, properties);
        this.itemId = Objects.requireNonNull(itemId, "itemId");
        this.visuals = Objects.requireNonNull(visuals, "visuals");
        this.bones = Objects.requireNonNull(bones, "bones");
        this.attributes = List.copyOf(attributes);
    }

    public void addVisionCapability(String capability) {
        if (!this.visionCapabilities.contains(capability)) {
            this.visionCapabilities.add(capability);
        }
    }

    public boolean hasVisionCapability(String capability) {
        return this.visionCapabilities.contains(capability);
    }

    public SoundEvent m_150681_() {
        return SoundEvents.f_271165_;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private WarbornArmorRenderer renderer;

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> defaultModel) {
                if (this.renderer == null) {
                    this.renderer = new WarbornArmorRenderer(WarbornArmorItem.this.visuals, WarbornArmorItem.this.bones);
                }
                this.renderer.prepForRender((Entity)livingEntity, stack, slot, defaultModel);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        if (this.m_266204_() == ArmorItem.Type.HELMET && this.visuals.animation() != null) {
            controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "nvg_toggle", 0, state -> {
                LivingEntity entity;
                ItemStack stack = (ItemStack)state.getData(DataTickets.ITEMSTACK);
                Entity rawEntity = (Entity)state.getData(DataTickets.ENTITY);
                if (!(rawEntity instanceof LivingEntity) || (entity = (LivingEntity)rawEntity) instanceof ArmorStand) {
                    return PlayState.STOP;
                }
                if (stack == null || !stack.m_41782_()) {
                    state.setAnimation(RawAnimation.begin().then(NBT_NVG_DOWN, Animation.LoopType.HOLD_ON_LAST_FRAME));
                    return PlayState.CONTINUE;
                }
                boolean nvgDown = stack.m_41784_().m_128471_(NBT_NVG_DOWN);
                String animationName = nvgDown ? NBT_NVG_DOWN : "nvg_up";
                state.setAnimation(RawAnimation.begin().then(animationName, Animation.LoopType.HOLD_ON_LAST_FRAME));
                return PlayState.CONTINUE;
            })});
        }
    }

    public void setNVGUp(ItemStack stack, boolean up) {
        stack.m_41784_().m_128379_("nvg_up", up);
    }

    public boolean isNVGUp(ItemStack stack) {
        return stack.m_41784_().m_128471_("nvg_up");
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap modifiers = super.m_7167_(slot);
        if (!this.attributes.isEmpty() && slot == this.m_266204_().m_266308_()) {
            modifiers = HashMultimap.create((Multimap)modifiers);
            for (int i = 0; i < this.attributes.size(); ++i) {
                ArmorAttributeSpec spec = this.attributes.get(i);
                Attribute attribute = spec.attribute();
                UUID uuid = UUID.nameUUIDFromBytes((this.itemId + "/" + slot.m_20751_() + "#" + i).getBytes(StandardCharsets.UTF_8));
                modifiers.put((Object)attribute, (Object)spec.createModifier(uuid, stack, "warbornrenewed:" + this.itemId, slot));
            }
        }
        return modifiers;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        String materialName = this.m_40401_().toString().toLowerCase();
        String materialKey = "material.warbornrenewed." + materialName;
        MutableComponent materialDisplayName = Component.m_237115_((String)materialKey);
        tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.warbornrenewed.material", (Object[])new Object[]{materialDisplayName}).m_130940_(ChatFormatting.GRAY));
        EquipmentSlot slot = this.m_266204_().m_266308_();
        Multimap<Attribute, AttributeModifier> mods = this.getAttributeModifiers(slot, stack);
        double bulletRes = 0.0;
        int protClass = 0;
        double thickness = 0.0;
        double blastMult = 1.0;
        double moveMod = 0.0;
        Attribute bulletAttr = (Attribute)ModAttributes.BULLET_RESISTANCE.get();
        Attribute protAttr = (Attribute)ModAttributes.PROTECTION_CLASS.get();
        Attribute thickAttr = (Attribute)ModAttributes.EFFECTIVE_THICKNESS.get();
        Attribute blastAttr = (Attribute)ModAttributes.BLAST_DAMAGE_MULTIPLIER.get();
        Attribute moveAttr = (Attribute)ModAttributes.ARMOR_MOVEMENT_SPEED.get();
        if (mods != null && !mods.isEmpty()) {
            for (Map.Entry entry : mods.entries()) {
                Attribute attr = (Attribute)entry.getKey();
                AttributeModifier mod = (AttributeModifier)entry.getValue();
                double amt = mod.m_22218_();
                if (attr == bulletAttr) {
                    if (mod.m_22217_() == AttributeModifier.Operation.ADDITION) {
                        bulletRes += amt;
                        continue;
                    }
                    if (mod.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE) continue;
                    bulletRes *= 1.0 + amt;
                    continue;
                }
                if (attr == protAttr) {
                    if (mod.m_22217_() != AttributeModifier.Operation.ADDITION) continue;
                    protClass += (int)Math.round(amt);
                    continue;
                }
                if (attr == thickAttr) {
                    if (mod.m_22217_() != AttributeModifier.Operation.ADDITION) continue;
                    thickness += amt;
                    continue;
                }
                if (attr == blastAttr) {
                    if (mod.m_22217_() == AttributeModifier.Operation.MULTIPLY_BASE) {
                        blastMult *= 1.0 + amt;
                        continue;
                    }
                    if (mod.m_22217_() != AttributeModifier.Operation.ADDITION) continue;
                    blastMult += amt;
                    continue;
                }
                if (attr != moveAttr) continue;
                if (mod.m_22217_() == AttributeModifier.Operation.ADDITION) {
                    moveMod += amt;
                    continue;
                }
                if (mod.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE) continue;
                moveMod *= 1.0 + amt;
            }
        }
        bulletRes = Math.max(0.0, Math.min(1.0, bulletRes));
        protClass = Math.max(0, Math.min(6, protClass));
        thickness = Math.max(0.0, thickness);
        int bulletPercent = (int)Math.round(bulletRes * 100.0);
        tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.warbornrenewed.bullet_resistance", (Object[])new Object[]{String.valueOf(bulletPercent)}).m_130940_(ChatFormatting.DARK_GREEN));
        String pcKey = "protection_class.warbornrenewed." + protClass;
        MutableComponent pcText = Component.m_237115_((String)pcKey);
        tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.warbornrenewed.protection_class", (Object[])new Object[]{pcText}).m_130940_(ChatFormatting.BLUE));
        String thicknessStr = thickness % 1.0 == 0.0 ? String.format("%.0f", thickness) : String.format("%.1f", thickness);
        tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.warbornrenewed.effective_thickness", (Object[])new Object[]{thicknessStr}).m_130940_(ChatFormatting.GRAY));
        int blastPercent = (int)Math.round((1.0 - blastMult) * 100.0);
        tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.warbornrenewed.blast_resistance", (Object[])new Object[]{String.valueOf(blastPercent)}).m_130940_(blastPercent >= 0 ? ChatFormatting.DARK_GREEN : ChatFormatting.RED));
        int speedPercent = (int)Math.round(moveMod * 100.0);
        tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.warbornrenewed.movement_speed", (Object[])new Object[]{String.valueOf(speedPercent)}).m_130940_(speedPercent >= 0 ? ChatFormatting.GREEN : ChatFormatting.RED));
        if (this.m_266204_() == ArmorItem.Type.HELMET && this.hasAnyVisionCapability()) {
            tooltipComponents.add((Component)Component.m_237119_());
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.warbornrenewed.vision_capabilities").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
            if (this.hasVisionCapability(TAG_NVG)) {
                tooltipComponents.add((Component)Component.m_237113_((String)"  \u2022 ").m_7220_((Component)Component.m_237115_((String)"tooltip.warbornrenewed.vision.nvg")).m_130940_(ChatFormatting.GREEN));
            }
            if (this.hasVisionCapability(TAG_THERMAL)) {
                tooltipComponents.add((Component)Component.m_237113_((String)"  \u2022 ").m_7220_((Component)Component.m_237115_((String)"tooltip.warbornrenewed.vision.thermal")).m_130940_(ChatFormatting.LIGHT_PURPLE));
            }
            if (this.hasVisionCapability(TAG_NVG)) {
                boolean nvgDown = stack.m_41784_().m_128471_(NBT_NVG_DOWN);
                MutableComponent statusKey = nvgDown ? Component.m_237115_((String)"tooltip.warbornrenewed.nvg.down").m_130940_(ChatFormatting.GREEN) : Component.m_237115_((String)"tooltip.warbornrenewed.nvg.up").m_130940_(ChatFormatting.GRAY);
                tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.warbornrenewed.nvg.status", (Object[])new Object[]{statusKey}));
            }
        }
    }

    public boolean hasAnyVisionCapability() {
        return !this.visionCapabilities.isEmpty();
    }

    public static boolean isNVGDown(ItemStack stack) {
        return stack.m_41784_().m_128471_(NBT_NVG_DOWN);
    }

    public static void toggleNVG(ItemStack stack) {
        CompoundTag tag;
        boolean current = (tag = stack.m_41784_()).m_128471_(NBT_NVG_DOWN);
        tag.m_128379_(NBT_NVG_DOWN, !current);
    }

    public static void setNVGDown(ItemStack stack, boolean down) {
        stack.m_41784_().m_128379_(NBT_NVG_DOWN, down);
    }

    public static boolean isHelmetOpen(ItemStack stack) {
        return stack.m_41784_().m_128471_(NBT_HELMET_OPEN);
    }

    public static void toggleHelmet(ItemStack stack) {
        CompoundTag tag;
        boolean current = (tag = stack.m_41784_()).m_128471_(NBT_HELMET_OPEN);
        tag.m_128379_(NBT_HELMET_OPEN, !current);
    }

    public static void setHelmetOpen(ItemStack stack, boolean open) {
        stack.m_41784_().m_128379_(NBT_HELMET_OPEN, open);
    }

    public String getItemId() {
        return this.itemId;
    }

    public ArmorVisualSpec getVisuals() {
        return this.visuals;
    }

    @Nullable
    public ResourceLocation getNvgShader() {
        return this.visuals.nvgShader();
    }

    public ArmorBonesSpec getBones() {
        return this.bones;
    }
}

