/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.warbornrenewed.content.armorset;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import ru.liko.warbornrenewed.Warbornrenewed;

public record ArmorVisualSpec(ResourceLocation model, ResourceLocation texture, @Nullable ResourceLocation animation, @Nullable ResourceLocation nvgShader) {
    public ArmorVisualSpec {
        Objects.requireNonNull(model, "model");
        Objects.requireNonNull(texture, "texture");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ResourceLocation model;
        private ResourceLocation texture;
        private ResourceLocation animation;
        private ResourceLocation nvgShader;

        private Builder() {
        }

        public Builder model(ResourceLocation model) {
            this.model = Objects.requireNonNull(model, "model");
            return this;
        }

        public Builder model(String path) {
            return this.model(Builder.resolve(path));
        }

        public Builder texture(ResourceLocation texture) {
            this.texture = Objects.requireNonNull(texture, "texture");
            return this;
        }

        public Builder texture(String path) {
            return this.texture(Builder.resolve(path));
        }

        public Builder animation(@Nullable ResourceLocation animation) {
            this.animation = animation;
            return this;
        }

        public Builder animation(String path) {
            return this.animation(Builder.resolve(path));
        }

        public Builder nvgShader(@Nullable ResourceLocation shader) {
            this.nvgShader = shader;
            return this;
        }

        public Builder nvgShader(String path) {
            return this.nvgShader(Builder.resolve(path));
        }

        public ArmorVisualSpec build() {
            Objects.requireNonNull(this.model, "model");
            Objects.requireNonNull(this.texture, "texture");
            return new ArmorVisualSpec(this.model, this.texture, this.animation, this.nvgShader);
        }

        private static ResourceLocation resolve(String path) {
            if (path.contains(":")) {
                int idx = path.indexOf(58);
                String namespace = path.substring(0, idx);
                String resourcePath = path.substring(idx + 1);
                return new ResourceLocation(namespace, resourcePath);
            }
            return Warbornrenewed.id(path);
        }
    }
}

