/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.warbornrenewed.content.armorset;

import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ru.liko.warbornrenewed.content.armorset.WarbornArmorItem;
import ru.liko.warbornrenewed.registry.ModAttributes;

@Mod.EventBusSubscriber(modid="warbornrenewed", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ArmorMovementHandler {
    private static final UUID ARMOR_SPEED_UUID = UUID.fromString("5d3f8f8a-8e2e-4e9f-9f2f-9f7e1cc9e6b1");

    private ArmorMovementHandler() {
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity == null || entity.m_9236_().f_46443_) {
            return;
        }
        double totalSpeedModifier = 0.0;
        for (EquipmentSlot slot : new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET}) {
            Item item;
            ItemStack stack = entity.m_6844_(slot);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof WarbornArmorItem)) continue;
            WarbornArmorItem armorItem = (WarbornArmorItem)item;
            Multimap<Attribute, AttributeModifier> itemMods = armorItem.getAttributeModifiers(slot, stack);
            Attribute moveAttr = (Attribute)ModAttributes.ARMOR_MOVEMENT_SPEED.get();
            if (itemMods == null || itemMods.isEmpty()) continue;
            for (Map.Entry entry : itemMods.entries()) {
                if (entry.getKey() != moveAttr) continue;
                AttributeModifier mod = (AttributeModifier)entry.getValue();
                if (mod.m_22217_() == AttributeModifier.Operation.ADDITION) {
                    totalSpeedModifier += mod.m_22218_();
                    continue;
                }
                if (mod.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE) continue;
                totalSpeedModifier *= 1.0 + mod.m_22218_();
            }
        }
        AttributeInstance movement = entity.m_21051_(Attributes.f_22279_);
        if (movement == null) {
            return;
        }
        AttributeModifier existing = movement.m_22111_(ARMOR_SPEED_UUID);
        if (existing != null) {
            movement.m_22130_(existing);
        }
        if (Math.abs(totalSpeedModifier) > 1.0E-6) {
            AttributeModifier applied = new AttributeModifier(ARMOR_SPEED_UUID, "warbornrenewed:armor_movement_speed", totalSpeedModifier, AttributeModifier.Operation.MULTIPLY_BASE);
            movement.m_22125_(applied);
        }
    }
}

