/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.warbornrenewed.content.armorset;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import ru.liko.warbornrenewed.registry.ModAttributes;

public final class ArmorAttributeSpec {
    private final Supplier<Attribute> attribute;
    private final String idSuffix;
    private final AttributeModifier.Operation operation;
    private final double baseValue;
    private final boolean scaleWithDurability;

    private ArmorAttributeSpec(Supplier<Attribute> attribute, String idSuffix, AttributeModifier.Operation operation, double baseValue, boolean scaleWithDurability) {
        this.attribute = Objects.requireNonNull(attribute, "attribute");
        this.idSuffix = Objects.requireNonNull(idSuffix, "idSuffix");
        this.operation = Objects.requireNonNull(operation, "operation");
        this.baseValue = baseValue;
        this.scaleWithDurability = scaleWithDurability;
    }

    public Attribute attribute() {
        return this.attribute.get();
    }

    public AttributeModifier createModifier(UUID uuid, ItemStack stack, String itemId, EquipmentSlot slot) {
        Preconditions.checkNotNull((Object)uuid, (Object)"uuid");
        Preconditions.checkNotNull((Object)stack, (Object)"stack");
        Preconditions.checkNotNull((Object)itemId, (Object)"itemId");
        double amount = this.baseValue;
        if (this.scaleWithDurability && stack.m_41763_() && stack.m_41776_() > 0) {
            double ratio = 1.0 - (double)stack.m_41773_() / (double)stack.m_41776_();
            amount *= Math.max(0.0, ratio);
        }
        return new AttributeModifier(uuid, itemId + "/" + this.idSuffix, amount, this.operation);
    }

    public static ArmorAttributeSpec bulletResistance(double value) {
        return ArmorAttributeSpec.bulletResistance(value, true);
    }

    public static ArmorAttributeSpec bulletResistance(double value, boolean scaleWithDurability) {
        return new ArmorAttributeSpec(() -> ModAttributes.BULLET_RESISTANCE.get(), "bullet_resistance", AttributeModifier.Operation.ADDITION, value, scaleWithDurability);
    }

    public static ArmorAttributeSpec protectionClass(int protectionClass) {
        return new ArmorAttributeSpec(() -> ModAttributes.PROTECTION_CLASS.get(), "protection_class", AttributeModifier.Operation.ADDITION, protectionClass, false);
    }

    public static ArmorAttributeSpec effectiveThickness(double thickness) {
        return new ArmorAttributeSpec(() -> ModAttributes.EFFECTIVE_THICKNESS.get(), "effective_thickness", AttributeModifier.Operation.ADDITION, thickness, false);
    }

    public static ArmorAttributeSpec blastResistance(double multiplier) {
        return new ArmorAttributeSpec(() -> ModAttributes.BLAST_DAMAGE_MULTIPLIER.get(), "blast_damage_multiplier", AttributeModifier.Operation.MULTIPLY_BASE, multiplier - 1.0, false);
    }

    public static ArmorAttributeSpec movementSpeed(double speedModifier) {
        return new ArmorAttributeSpec(() -> ModAttributes.ARMOR_MOVEMENT_SPEED.get(), "armor_movement_speed", AttributeModifier.Operation.ADDITION, speedModifier, false);
    }

    public static ArmorAttributeSpec of(Supplier<Attribute> attribute, String idSuffix, AttributeModifier.Operation operation, double value, boolean scaleWithDurability) {
        return new ArmorAttributeSpec(attribute, idSuffix, operation, value, scaleWithDurability);
    }
}

