/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.warbornrenewed.client.shader;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.liko.warbornrenewed.content.armorset.WarbornArmorItem;

@OnlyIn(value=Dist.CLIENT)
public final class VisionShaderRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(VisionShaderRegistry.class);
    private static final VisionShaderRegistry INSTANCE = new VisionShaderRegistry();
    private static final Field POST_CHAIN_PASSES_FIELD = VisionShaderRegistry.locatePassesField();
    private final Map<String, ShaderEntry> shaders = new LinkedHashMap<String, ShaderEntry>();
    private String currentActiveShader;
    private boolean internalShutdownInProgress;

    private VisionShaderRegistry() {
    }

    public static VisionShaderRegistry getInstance() {
        return INSTANCE;
    }

    public static List<PostPass> getPasses(PostChain chain) {
        try {
            if (POST_CHAIN_PASSES_FIELD == null) {
                return List.of();
            }
            List passes = (List)POST_CHAIN_PASSES_FIELD.get(chain);
            return passes;
        }
        catch (Exception e) {
            LOGGER.error("Failed to access PostChain passes", (Throwable)e);
            return List.of();
        }
    }

    public boolean registerShader(String id, ResourceLocation shaderLocation, Predicate<Minecraft> activationCondition, Consumer<PostChain> configurer) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(shaderLocation, "shaderLocation");
        Objects.requireNonNull(activationCondition, "activationCondition");
        Objects.requireNonNull(configurer, "configurer");
        if (this.shaders.containsKey(id)) {
            LOGGER.warn("Shader with id '{}' is already registered", (Object)id);
            return false;
        }
        this.shaders.put(id, new ShaderEntry(shaderLocation, activationCondition, configurer));
        return true;
    }

    public void unregisterShader(String id) {
        ShaderEntry removed = this.shaders.remove(id);
        if (removed != null && Objects.equals(this.currentActiveShader, id)) {
            this.shutdownCurrent(Minecraft.m_91087_());
        }
    }

    public Set<String> getRegisteredShaderIds() {
        return Set.copyOf(this.shaders.keySet());
    }

    public Optional<String> getCurrentActiveShaderId() {
        return Optional.ofNullable(this.currentActiveShader);
    }

    public boolean isShaderActive() {
        return this.currentActiveShader != null;
    }

    public boolean isShaderForceEnabled(String id) {
        ShaderEntry entry = this.shaders.get(id);
        return entry != null && Boolean.TRUE.equals(entry.forceEnabled);
    }

    public boolean setShaderEnabled(String id, boolean enabled) {
        ShaderEntry entry = this.shaders.get(id);
        if (entry == null) {
            return false;
        }
        entry.forceEnabled = enabled;
        if (!enabled && Objects.equals(this.currentActiveShader, id)) {
            this.shutdownCurrent(Minecraft.m_91087_());
        }
        return true;
    }

    public void processShaders(Minecraft minecraft) {
        PostChain currentEffect;
        if (minecraft == null) {
            return;
        }
        if (minecraft.f_91073_ == null || minecraft.f_91074_ == null) {
            this.shutdownCurrent(minecraft);
            return;
        }
        ItemStack helmet = minecraft.f_91074_.m_6844_(EquipmentSlot.HEAD);
        if (!helmet.m_41619_() && helmet.m_41720_() instanceof WarbornArmorItem && WarbornArmorItem.isHelmetOpen(helmet)) {
            this.shutdownCurrent(minecraft);
            return;
        }
        String shaderToActivate = null;
        ShaderEntry entryToActivate = null;
        for (Map.Entry<String, ShaderEntry> entry : this.shaders.entrySet()) {
            ShaderEntry shaderEntry = entry.getValue();
            boolean activatedByCondition = shaderEntry.activationCondition.test(minecraft);
            boolean forceDisabled = Boolean.FALSE.equals(shaderEntry.forceEnabled);
            boolean forceEnabled = Boolean.TRUE.equals(shaderEntry.forceEnabled);
            boolean shouldBeActive = activatedByCondition && !forceDisabled || forceEnabled;
            if (!shouldBeActive) continue;
            shaderToActivate = entry.getKey();
            entryToActivate = shaderEntry;
            break;
        }
        GameRenderer gameRenderer = minecraft.f_91063_;
        if (shaderToActivate == null) {
            if (this.currentActiveShader != null) {
                this.shutdownCurrent(minecraft);
            }
            return;
        }
        if (!shaderToActivate.equals(this.currentActiveShader)) {
            try {
                gameRenderer.m_109128_(entryToActivate.shaderLocation);
                this.currentActiveShader = shaderToActivate;
            }
            catch (Exception e) {
                LOGGER.error("Failed to load shader {}", (Object)shaderToActivate, (Object)e);
                this.shutdownCurrent(minecraft);
                return;
            }
        }
        if ((currentEffect = gameRenderer.m_109149_()) != null) {
            try {
                entryToActivate.configurer.accept(currentEffect);
            }
            catch (Exception e) {
                LOGGER.error("Failed to configure shader {}", (Object)shaderToActivate, (Object)e);
            }
        }
    }

    public void shutdown() {
        this.shutdownCurrent(Minecraft.m_91087_());
    }

    public boolean isInternalShutdownInProgress() {
        return this.internalShutdownInProgress;
    }

    public void onResourceReload() {
        this.shutdown();
    }

    private void shutdownCurrent(Minecraft minecraft) {
        if (minecraft == null) {
            this.currentActiveShader = null;
            return;
        }
        if (this.currentActiveShader != null) {
            try {
                this.internalShutdownInProgress = true;
                minecraft.f_91063_.m_109086_();
            }
            finally {
                this.internalShutdownInProgress = false;
            }
            this.currentActiveShader = null;
        }
    }

    private static Field locatePassesField() {
        try {
            Field field = ObfuscationReflectionHelper.findField(PostChain.class, (String)"passes");
            field.setAccessible(true);
            return field;
        }
        catch (ObfuscationReflectionHelper.UnableToFindFieldException ex) {
            try {
                Field field = ObfuscationReflectionHelper.findField(PostChain.class, (String)"f_110009_");
                field.setAccessible(true);
                return field;
            }
            catch (ObfuscationReflectionHelper.UnableToFindFieldException obfEx) {
                LOGGER.error("Unable to locate PostChain passes field via reflection", (Throwable)obfEx);
                return null;
            }
        }
    }

    private static final class ShaderEntry {
        final ResourceLocation shaderLocation;
        final Predicate<Minecraft> activationCondition;
        final Consumer<PostChain> configurer;
        Boolean forceEnabled;

        ShaderEntry(ResourceLocation shaderLocation, Predicate<Minecraft> activationCondition, Consumer<PostChain> configurer) {
            this.shaderLocation = shaderLocation;
            this.activationCondition = activationCondition;
            this.configurer = configurer;
        }
    }
}

