/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.warbornrenewed.client.shader;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.liko.warbornrenewed.Warbornrenewed;
import ru.liko.warbornrenewed.client.shader.VisionShaderRegistry;
import ru.liko.warbornrenewed.content.armorset.WarbornArmorItem;
import ru.liko.warbornrenewed.registry.ModItems;

@OnlyIn(value=Dist.CLIENT)
public final class VisionShaderManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(VisionShaderManager.class);
    private static final String NVG_SHADER_ID_PREFIX = "nvg/";
    private static final String THERMAL_SHADER_ID = "thermal";
    private static final ResourceLocation DEFAULT_NVG_SHADER = Warbornrenewed.id("shaders/post/pnv10t.json");
    private static final ResourceLocation THERMAL_SHADER = Warbornrenewed.id("shaders/post/thermal.json");

    private VisionShaderManager() {
    }

    public static void registerShaders() {
        VisionShaderRegistry registry = VisionShaderRegistry.getInstance();
        VisionShaderManager.registerNightVisionShaders(registry);
        VisionShaderManager.registerThermalShader(registry);
    }

    private static void registerNightVisionShaders(VisionShaderRegistry registry) {
        for (RegistryObject<? extends Item> entry : ModItems.armorPieces()) {
            String shaderId;
            boolean registered;
            WarbornArmorItem armorItem;
            Item registryItem = (Item)entry.get();
            if (!(registryItem instanceof WarbornArmorItem) || !(armorItem = (WarbornArmorItem)registryItem).hasVisionCapability("nvg")) continue;
            ResourceLocation shaderLocation = armorItem.getNvgShader();
            if (shaderLocation == null) {
                shaderLocation = DEFAULT_NVG_SHADER;
            }
            if (registered = registry.registerShader(shaderId = NVG_SHADER_ID_PREFIX + armorItem.getItemId(), shaderLocation, minecraft -> VisionShaderManager.isNightVisionActive(minecraft, armorItem), VisionShaderManager::configureNightVision)) {
                LOGGER.debug("Registered NVG shader '{}' with id '{}' for helmet '{}'", new Object[]{shaderLocation, shaderId, armorItem.getItemId()});
                continue;
            }
            LOGGER.debug("NVG shader with id '{}' was already registered", (Object)shaderId);
        }
    }

    private static void registerThermalShader(VisionShaderRegistry registry) {
        boolean thermalRegistered = registry.registerShader(THERMAL_SHADER_ID, THERMAL_SHADER, VisionShaderManager::isThermalVisionActive, VisionShaderManager::configureThermalVision);
        if (thermalRegistered) {
            LOGGER.debug("Registered Thermal shader with id '{}'", (Object)THERMAL_SHADER_ID);
        } else {
            LOGGER.debug("Thermal shader with id '{}' was already registered", (Object)THERMAL_SHADER_ID);
        }
    }

    public static void processShaders(Minecraft minecraft) {
        VisionShaderRegistry.getInstance().processShaders(minecraft);
    }

    public static void disableShader() {
        VisionShaderRegistry.getInstance().shutdown();
    }

    public static boolean isShaderActive() {
        return VisionShaderRegistry.getInstance().isShaderActive();
    }

    public static void onResourceReload() {
        VisionShaderRegistry.getInstance().onResourceReload();
    }

    public static boolean isThermalShaderActive() {
        return VisionShaderRegistry.getInstance().getCurrentActiveShaderId().filter(THERMAL_SHADER_ID::equals).isPresent();
    }

    private static boolean isNightVisionActive(Minecraft minecraft, WarbornArmorItem targetHelmet) {
        Item item;
        if (minecraft == null || minecraft.f_91074_ == null) {
            return false;
        }
        ItemStack helmet = minecraft.f_91074_.m_6844_(EquipmentSlot.HEAD);
        if (helmet.m_41619_() || !((item = helmet.m_41720_()) instanceof WarbornArmorItem)) {
            return false;
        }
        WarbornArmorItem armorItem = (WarbornArmorItem)item;
        if (armorItem != targetHelmet) {
            return false;
        }
        if (!armorItem.hasVisionCapability("nvg")) {
            return false;
        }
        if (!WarbornArmorItem.isNVGDown(helmet)) {
            return false;
        }
        return !WarbornArmorItem.isHelmetOpen(helmet);
    }

    private static boolean isThermalVisionActive(Minecraft minecraft) {
        Item item;
        if (minecraft == null || minecraft.f_91074_ == null) {
            return false;
        }
        ItemStack helmet = minecraft.f_91074_.m_6844_(EquipmentSlot.HEAD);
        if (helmet.m_41619_() || !((item = helmet.m_41720_()) instanceof WarbornArmorItem)) {
            return false;
        }
        WarbornArmorItem armorItem = (WarbornArmorItem)item;
        if (!armorItem.hasVisionCapability(THERMAL_SHADER_ID)) {
            return false;
        }
        if (!WarbornArmorItem.isNVGDown(helmet)) {
            return false;
        }
        return !WarbornArmorItem.isHelmetOpen(helmet);
    }

    private static void configureNightVision(PostChain postChain) {
        Minecraft minecraft = Minecraft.m_91087_();
        float time = 0.0f;
        if (minecraft != null) {
            time = minecraft.f_91073_ != null ? ((float)minecraft.f_91073_.m_46467_() + minecraft.m_91296_()) / 20.0f : minecraft.m_91296_() / 20.0f;
        }
        List<PostPass> passes = VisionShaderRegistry.getPasses(postChain);
        for (PostPass pass : passes) {
            if (pass.m_110074_().m_108952_("NightVisionEnabled") != null) {
                pass.m_110074_().m_108960_("NightVisionEnabled").m_5985_(1.0f);
            }
            if (pass.m_110074_().m_108952_("VignetteEnabled") != null) {
                pass.m_110074_().m_108960_("VignetteEnabled").m_5985_(1.0f);
            }
            if (pass.m_110074_().m_108952_("Time") == null) continue;
            pass.m_110074_().m_108960_("Time").m_5985_(time);
        }
    }

    private static void configureThermalVision(PostChain postChain) {
        Minecraft minecraft = Minecraft.m_91087_();
        float time = 0.0f;
        if (minecraft != null) {
            time = minecraft.f_91073_ != null ? ((float)minecraft.f_91073_.m_46467_() + minecraft.m_91296_()) / 20.0f : minecraft.m_91296_() / 20.0f;
        }
        List<PostPass> passes = VisionShaderRegistry.getPasses(postChain);
        for (PostPass pass : passes) {
            if (pass.m_110074_().m_108952_("VignetteEnabled") != null) {
                pass.m_110074_().m_108960_("VignetteEnabled").m_5985_(1.0f);
            }
            if (pass.m_110074_().m_108952_("VignetteRadius") != null) {
                pass.m_110074_().m_108960_("VignetteRadius").m_5985_(0.65f);
            }
            if (pass.m_110074_().m_108952_("Brightness") != null) {
                pass.m_110074_().m_108960_("Brightness").m_5985_(1.1f);
            }
            if (pass.m_110074_().m_108952_("NoiseAmplification") != null) {
                pass.m_110074_().m_108960_("NoiseAmplification").m_5985_(2.2f);
            }
            if (pass.m_110074_().m_108952_("Time") == null) continue;
            pass.m_110074_().m_108960_("Time").m_5985_(time);
        }
    }
}

