/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.warbornrenewed.client;

import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import ru.liko.warbornrenewed.client.shader.VisionShaderManager;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="warbornrenewed", value={Dist.CLIENT})
public final class VisionShaderEvents {
    private VisionShaderEvents() {
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            return;
        }
        if ((mc.f_91074_ == null || mc.f_91073_ == null) && VisionShaderManager.isShaderActive()) {
            VisionShaderManager.disableShader();
        }
    }

    @SubscribeEvent
    public static void onClientLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        VisionShaderManager.disableShader();
    }

    @SubscribeEvent
    public static void registerReloadListener(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new SimplePreparableReloadListener<Void>(){

            protected Void prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
                return null;
            }

            protected void apply(Void object, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
                VisionShaderManager.onResourceReload();
            }
        });
    }

    @Mod.EventBusSubscriber(modid="warbornrenewed", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static final class ClientInit {
        private ClientInit() {
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(VisionShaderManager::registerShaders);
        }
    }
}

