/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.warbornrenewed.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ru.liko.warbornrenewed.client.KeyBindings;
import ru.liko.warbornrenewed.content.armorset.WarbornArmorItem;
import ru.liko.warbornrenewed.network.NVGTogglePacket;
import ru.liko.warbornrenewed.network.NetworkHandler;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="warbornrenewed", value={Dist.CLIENT})
public class NVGToggleHandler {
    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (KeyBindings.NVG_TOGGLE.m_90859_()) {
            NVGToggleHandler.handleVisionToggle((Player)player);
        }
    }

    private static void handleVisionToggle(Player player) {
        Item item;
        ItemStack helmet = player.m_150109_().m_36052_(3);
        if (helmet.m_41619_() || !((item = helmet.m_41720_()) instanceof WarbornArmorItem)) {
            return;
        }
        WarbornArmorItem armorItem = (WarbornArmorItem)item;
        boolean supportsNVG = armorItem.hasVisionCapability("nvg");
        boolean supportsThermal = armorItem.hasVisionCapability("thermal");
        if (!supportsNVG && !supportsThermal) {
            return;
        }
        boolean currentState = WarbornArmorItem.isNVGDown(helmet);
        boolean newState = !currentState;
        WarbornArmorItem.setNVGDown(helmet, newState);
        NetworkHandler.sendToServer(new NVGTogglePacket(newState));
    }
}

