/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource;

import cn.sh1rocu.tacz.util.forge.DelegatingPackResources;
import cn.sh1rocu.tacz.util.forge.PathPackResources;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.resource.ResourceManager;
import com.tacz.guns.config.PreLoadConfig;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.PackMeta;
import com.tacz.guns.util.GetJarResources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.zip.ZipFile;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_3258;
import net.minecraft.class_3264;
import net.minecraft.class_3272;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public enum GunPackLoader implements class_3285
{
    INSTANCE;

    private static final Marker MARKER;
    public class_3264 packType;
    private boolean firstLoad = true;

    public void method_14453(Consumer<class_3288> pOnLoad) {
        class_3288 extensionsPack = this.discoverExtensions();
        if (extensionsPack != null) {
            pOnLoad.accept(extensionsPack);
        }
    }

    public class_3288 discoverExtensions() {
        Path resourcePacksPath = FabricLoader.getInstance().getGameDir().resolve("tacz");
        File folder = resourcePacksPath.toFile();
        if (!folder.isDirectory()) {
            try {
                Files.createDirectories(folder.toPath(), new FileAttribute[0]);
            }
            catch (Exception e) {
                GunMod.LOGGER.warn(MARKER, "Failed to init tacz resource directory...", (Throwable)e);
                return null;
            }
        }
        PreLoadConfig.load(resourcePacksPath);
        if (this.firstLoad) {
            if (!((Boolean)PreLoadConfig.override.get()).booleanValue()) {
                for (ResourceManager.ExtraEntry entry : ResourceManager.EXTRA_ENTRIES) {
                    GetJarResources.copyModDirectory(entry.modMainClass(), entry.srcPath(), resourcePacksPath, entry.extraDirName());
                }
            }
            this.firstLoad = false;
        }
        GunMod.LOGGER.info(MARKER, "Start scanning for gun packs in {}", (Object)resourcePacksPath);
        List<GunPack> gunPacks = GunPackLoader.scanExtensions(resourcePacksPath);
        GunMod.LOGGER.info(MARKER, "Found {} possible gunpack(s) and added them to resource set.", (Object)gunPacks.size());
        ArrayList<class_3258> extensionPacks = new ArrayList<class_3258>();
        for (final GunPack gunPack : gunPacks) {
            Object packResources = Files.isDirectory(gunPack.path, new LinkOption[0]) ? new PathPackResources(gunPack.name, false, gunPack.path){

                @Override
                @NotNull
                protected Path resolve(String ... paths) {
                    if (paths.length < 1) {
                        throw new IllegalArgumentException("Missing path");
                    }
                    return gunPack.path.resolve(String.join((CharSequence)"/", paths));
                }
            } : new class_3258(gunPack.name, gunPack.path.toFile(), false);
            extensionPacks.add((class_3258)packResources);
        }
        return class_3288.method_45275((String)"tacz_resources", (class_2561)class_2561.method_43470((String)"TACZ Resources"), (boolean)true, id -> new DelegatingPackResources(id, false, new class_3272((class_2561)class_2561.method_43471((String)"tacz.resources.modresources"), class_155.method_16673().method_48017(this.packType)), extensionPacks){

            @Override
            public class_7367<InputStream> method_14410(String ... paths) {
                Path logoPath;
                if (paths.length == 1 && paths[0].equals("pack.png") && (logoPath = GunPackLoader.getModIcon("tacz")) != null) {
                    return class_7367.create((Path)logoPath);
                }
                return null;
            }
        }, (class_3264)this.packType, (class_3288.class_3289)class_3288.class_3289.field_14281, (class_5352)class_5352.field_25348);
    }

    @Nullable
    public static Path getModIcon(String modId) {
        Optional logoPath;
        Optional m = FabricLoader.getInstance().getModContainer(modId);
        if (m.isPresent() && (logoPath = ((ModContainer)m.get()).findPath("icon.png")).isPresent() && Files.exists((Path)logoPath.get(), new LinkOption[0])) {
            return (Path)logoPath.get();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static GunPack fromDirPath(Path path) throws IOException {
        Path packInfoFilePath = path.resolve("gunpack.meta.json");
        try (InputStream stream = Files.newInputStream(packInfoFilePath, new OpenOption[0]);){
            PackMeta info = (PackMeta)CommonAssetsManager.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), PackMeta.class);
            if (info == null) {
                GunMod.LOGGER.warn(MARKER, "Failed to read info json: {}", (Object)packInfoFilePath.getFileName());
                GunPack gunPack = null;
                return gunPack;
            }
            if (info.getDependencies() != null && !GunPackLoader.modVersionAllMatch(info)) {
                GunMod.LOGGER.warn(MARKER, "Mod version mismatch: {}", (Object)packInfoFilePath.getFileName());
                GunPack gunPack = null;
                return gunPack;
            }
            GunPack gunPack = new GunPack(path, info.getName());
            return gunPack;
        }
        catch (JsonIOException | JsonSyntaxException | IOException | VersionParsingException exception) {
            GunMod.LOGGER.warn(MARKER, "Failed to read info json: {}", (Object)packInfoFilePath.getFileName());
            GunMod.LOGGER.warn(exception.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static GunPack fromZipPath(Path path) {
        try {
            block23: {
                block22: {
                    block21: {
                        zipFile = new ZipFile(path.toFile());
                        extDescriptorEntry = zipFile.getEntry("gunpack.meta.json");
                        if (extDescriptorEntry == null) {
                            GunMod.LOGGER.error(GunPackLoader.MARKER, "Failed to load extension from ZIP {}. Error: {}", (Object)path.getFileName(), (Object)"No gunpack.meta.json found");
                            var3_5 = null;
                        }
                        ** GOTO lbl14
                        {
                            catch (Throwable var2_4) {
                                throw var2_4;
                            }
                            zipFile.close();
                            return var3_5;
lbl14:
                            // 1 sources

                            stream = zipFile.getInputStream(extDescriptorEntry);
                            try {
                                info = (PackMeta)CommonAssetsManager.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), PackMeta.class);
                                if (info == null) {
                                    GunMod.LOGGER.warn(GunPackLoader.MARKER, "Failed to read info json: {}", (Object)path.getFileName());
                                    var5_11 = null;
                                    if (stream == null) break block21;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (Throwable var4_10) {}
                            ** try [egrp 8[TRYBLOCK] [24 : 215->265)] { 
lbl25:
                            // 1 sources

                            try {
                                if (stream == null) throw var4_10;
                                try {
                                    stream.close();
                                    throw var4_10;
                                }
                                catch (Throwable var5_14) {
                                    var4_10.addSuppressed(var5_14);
                                }
                                throw var4_10;
                            }
                            catch (JsonIOException | JsonSyntaxException | IOException | VersionParsingException e) {
                                GunMod.LOGGER.error(GunPackLoader.MARKER, "Failed to load extension from ZIP {}. Error: {}", (Object)path.getFileName(), (Object)e);
                                return null;
                            }
lbl36:
                            // 1 sources

                            finally {
                                zipFile.close();
                            }
                        }
                        stream.close();
                    }
                    zipFile.close();
                    return var5_11;
lbl-1000:
                    // 1 sources

                    {
                        if (info.getDependencies() == null || GunPackLoader.modVersionAllMatch(info)) ** GOTO lbl-1000
                        GunMod.LOGGER.warn(GunPackLoader.MARKER, "Mod version mismatch: {}", (Object)path.getFileName());
                        var5_12 = null;
                        if (stream == null) break block22;
                    }
                    stream.close();
                }
                zipFile.close();
                return var5_12;
lbl-1000:
                // 1 sources

                {
                    var5_13 = new GunPack(path, info.getName());
                    if (stream == null) break block23;
                }
                stream.close();
            }
            zipFile.close();
            return var5_13;
        }
        catch (IOException e) {
            GunMod.LOGGER.error(GunPackLoader.MARKER, "Failed to load extension from ZIP {}. Error: {}", (Object)path.getFileName(), (Object)e);
            return null;
        }
    }

    private static List<GunPack> scanExtensions(Path extensionsPath) {
        ArrayList<GunPack> gunPacks = new ArrayList<GunPack>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(extensionsPath);){
            for (Path entry : stream) {
                GunPack gunPack = null;
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    gunPack = GunPackLoader.fromDirPath(entry);
                } else if (entry.toString().endsWith(".zip")) {
                    gunPack = GunPackLoader.fromZipPath(entry);
                }
                if (gunPack == null) continue;
                GunMod.LOGGER.info(MARKER, "- {}, Main namespace: {}", (Object)gunPack.path.getFileName(), (Object)gunPack.name);
                gunPacks.add(gunPack);
            }
        }
        catch (IOException e) {
            GunMod.LOGGER.error(MARKER, "Failed to scan extensions from {}. Error: {}", (Object)extensionsPath, (Object)e);
        }
        return gunPacks;
    }

    private static boolean modVersionAllMatch(PackMeta info) throws VersionParsingException {
        HashMap<String, String> dependencies = info.getDependencies();
        for (String modId : dependencies.keySet()) {
            if (GunPackLoader.modVersionMatch(modId, dependencies.get(modId))) continue;
            return false;
        }
        return true;
    }

    private static boolean modVersionMatch(String modId, String version) throws VersionParsingException {
        VersionPredicate versionRange = VersionPredicate.parse((String)version);
        return FabricLoader.getInstance().getModContainer(modId).map(mod -> {
            Version modVersion = mod.getMetadata().getVersion();
            return versionRange.test((Object)modVersion);
        }).orElse(false);
    }

    static {
        MARKER = MarkerFactory.getMarker((String)"GunPackFinder");
    }

    public record GunPack(Path path, String name) {
    }
}

