/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.renderer.block;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.tacz.guns.block.TargetBlock;
import com.tacz.guns.block.entity.TargetBlockEntity;
import com.tacz.guns.client.model.bedrock.BedrockModel;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.client.resource.InternalAssetLoader;
import com.tacz.guns.config.client.RenderConfig;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1068;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4844;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;

public class TargetRenderer
implements class_827<TargetBlockEntity> {
    private static final String UPPER_NAME = "target_upper";
    private static final String HEAD_NAME = "head";

    public TargetRenderer(class_5614.class_5615 context) {
    }

    public static Optional<BedrockModel> getModel() {
        return InternalAssetLoader.getBedrockModel(InternalAssetLoader.TARGET_MODEL_LOCATION);
    }

    public void render(TargetBlockEntity blockEntity, float partialTick, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        TargetRenderer.getModel().ifPresent(model -> {
            class_2680 blockState = blockEntity.method_11010();
            class_2350 facing = (class_2350)blockState.method_11654((class_2769)TargetBlock.FACING);
            BedrockPart headModel = model.getNode(HEAD_NAME);
            BedrockPart upperModel = model.getNode(UPPER_NAME);
            float deg = -class_3532.method_16439((float)partialTick, (float)blockEntity.oRot, (float)blockEntity.rot);
            upperModel.xRot = (float)Math.toRadians(deg);
            headModel.visible = false;
            poseStack.method_22903();
            poseStack.method_22904(0.5, 0.225, 0.5);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees((float)(facing.method_10161() * 90)));
            poseStack.method_22907(class_7833.field_40717.rotationDegrees(180.0f));
            poseStack.method_22904(0.0, -1.275, 0.0125);
            class_1921 renderType = class_1921.method_23580((class_2960)InternalAssetLoader.TARGET_TEXTURE_LOCATION);
            model.render(poseStack, class_811.field_4315, renderType, combinedLightIn, combinedOverlayIn);
            if (blockEntity.getOwner() != null) {
                poseStack.method_22904(0.0, 1.25, 0.0);
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(deg));
                class_310 minecraft = class_310.method_1551();
                Map map = minecraft.method_1582().method_4654(blockEntity.getOwner());
                class_2960 skin = map.containsKey(MinecraftProfileTexture.Type.SKIN) ? minecraft.method_1582().method_4656((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN) : class_1068.method_4648((UUID)class_4844.method_43343((GameProfile)blockEntity.getOwner()));
                headModel.visible = true;
                class_1921 skullRenderType = class_1921.method_23576((class_2960)skin);
                headModel.render(poseStack, class_811.field_4315, bufferIn.getBuffer(skullRenderType), combinedLightIn, class_4608.field_21444);
            }
            poseStack.method_22909();
        });
    }

    public int method_33893() {
        return (Integer)RenderConfig.TARGET_RENDER_DISTANCE.get();
    }

    public boolean shouldRenderOffScreen(TargetBlockEntity blockEntity) {
        return true;
    }
}

