/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.model.functional;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.model.BedrockAmmoModel;
import com.tacz.guns.client.model.BedrockGunModel;
import com.tacz.guns.client.model.IFunctionalRenderer;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.client.resource.pojo.display.gun.ShellEjection;
import com.tacz.guns.compat.iris.IrisCompat;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class ShellRender
implements IFunctionalRenderer {
    private final ConcurrentLinkedDeque<Data> SHELL_QUEUE = new ConcurrentLinkedDeque();
    public static boolean isSelf = false;
    private final BedrockGunModel bedrockGunModel;

    public ShellRender(BedrockGunModel bedrockGunModel) {
        this.bedrockGunModel = bedrockGunModel;
    }

    public void addShell(Vector3f randomVelocity) {
        if (this.SHELL_QUEUE.size() > 128) {
            this.SHELL_QUEUE.pollFirst();
        }
        double xRandom = Math.random() * (double)randomVelocity.x();
        double yRandom = Math.random() * (double)randomVelocity.y();
        double zRandom = Math.random() * (double)randomVelocity.z();
        Vector3f vector3f = new Vector3f((float)xRandom, (float)yRandom, (float)zRandom);
        this.SHELL_QUEUE.offerLast(new Data(System.currentTimeMillis(), vector3f));
    }

    private void renderShell(GunDisplayInstance display, GunData gunData, class_4587 poseStack, BedrockGunModel gunModel) {
        ShellEjection shellEjection = display.getShellEjection();
        if (shellEjection == null) {
            this.SHELL_QUEUE.clear();
            return;
        }
        TimelessAPI.getClientAmmoIndex(gunData.getAmmoId()).ifPresent(ammoIndex -> {
            BedrockAmmoModel model = ammoIndex.getShellModel();
            if (model == null) {
                return;
            }
            class_2960 location = ammoIndex.getShellTextureLocation();
            if (location == null) {
                return;
            }
            long lifeTime = (long)(shellEjection.getLivingTime() * 1000.0f);
            this.checkShellQueue(lifeTime);
            Vector3f initialVelocity = shellEjection.getInitialVelocity();
            Vector3f acceleration = shellEjection.getAcceleration();
            Vector3f angularVelocity = shellEjection.getAngularVelocity();
            for (Data data : this.SHELL_QUEUE) {
                if (data.normal != null || data.pose != null) continue;
                data.normal = new Matrix3f((Matrix3fc)poseStack.method_23760().method_23762());
                data.pose = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            }
            gunModel.delegateRender((poseStack1, vertexConsumer1, transformType1, light, overlay) -> this.SHELL_QUEUE.forEach(data -> this.renderSingleShell(transformType1, light, overlay, (Data)data, initialVelocity, acceleration, angularVelocity, model, location)));
        });
    }

    private void renderSingleShell(class_811 transformType1, int light, int overlay, Data data, Vector3f initialVelocity, Vector3f acceleration, Vector3f angularVelocity, BedrockAmmoModel model, class_2960 location) {
        if (data.normal == null && data.pose == null) {
            return;
        }
        class_4587 poseStack2 = new class_4587();
        poseStack2.method_23760().method_23762().mul((Matrix3fc)data.normal);
        poseStack2.method_23760().method_23761().mul((Matrix4fc)data.pose);
        long remindTime = System.currentTimeMillis() - data.timeStamp;
        double time = (double)remindTime / 1000.0;
        Vector3f randomOffset = data.randomOffset;
        double x = (double)(initialVelocity.x() + randomOffset.x()) * time + 0.5 * (double)acceleration.x() * time * time;
        double y = (double)(initialVelocity.y() + randomOffset.y()) * time + 0.5 * (double)acceleration.y() * time * time;
        double z = (double)(initialVelocity.z() + randomOffset.z()) * time + 0.5 * (double)acceleration.z() * time * time;
        poseStack2.method_22904(-x, -y, z);
        double xw = time * (double)angularVelocity.x();
        double yw = time * (double)angularVelocity.y();
        double zw = time * (double)angularVelocity.z();
        poseStack2.method_22907(class_7833.field_40713.rotationDegrees((float)xw));
        poseStack2.method_22907(class_7833.field_40715.rotationDegrees((float)yw));
        poseStack2.method_22907(class_7833.field_40718.rotationDegrees((float)zw));
        poseStack2.method_22904(0.0, -1.5, 0.0);
        model.render(poseStack2, transformType1, class_1921.method_23576((class_2960)location), light, overlay);
    }

    private void checkShellQueue(long lifeTime) {
        if (!this.SHELL_QUEUE.isEmpty()) {
            Data data = this.SHELL_QUEUE.peekFirst();
            if (System.currentTimeMillis() - data.timeStamp > lifeTime) {
                this.SHELL_QUEUE.pollFirst();
                this.checkShellQueue(lifeTime);
            }
        }
    }

    @Override
    public void render(class_4587 poseStack, class_4588 vertexBuffer, class_811 transformType, int light, int overlay) {
        if (IrisCompat.isRenderShadow()) {
            return;
        }
        if (!isSelf) {
            return;
        }
        class_1799 currentGunItem = this.bedrockGunModel.getCurrentGunItem();
        IGun iGun = IGun.getIGunOrNull(currentGunItem);
        if (iGun == null) {
            return;
        }
        GunData gunData = TimelessAPI.getClientGunIndex(iGun.getGunId(currentGunItem)).map(ClientGunIndex::getGunData).orElse(null);
        if (gunData == null) {
            return;
        }
        TimelessAPI.getGunDisplay(currentGunItem).ifPresent(display -> this.renderShell((GunDisplayInstance)display, gunData, poseStack, this.bedrockGunModel));
    }

    public static class Data {
        public final long timeStamp;
        public final Vector3f randomOffset;
        public Matrix3f normal = null;
        public Matrix4f pose = null;

        public Data(long timeStamp, Vector3f randomOffset) {
            this.timeStamp = timeStamp;
            this.randomOffset = randomOffset;
        }
    }
}

