/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.violetmoon.quark.base.handler.QuarkSounds;
import org.violetmoon.quark.content.mobs.entity.Foxhound;
import org.violetmoon.quark.content.tweaks.ai.NuzzleGoal;
import org.violetmoon.quark.content.tweaks.ai.WantLoveGoal;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.play.entity.ZEntityJoinLevel;
import org.violetmoon.zeta.event.play.entity.living.ZAnimalTame;
import org.violetmoon.zeta.event.play.entity.player.ZPlayerInteract;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.MiscUtil;

@ZetaLoadModule(category="tweaks")
public class PatTheDogsModule
extends ZetaModule {
    @Config(description="How many ticks it takes for a dog to want affection after being pet/tamed; leave -1 to disable")
    public static int dogsWantLove = -1;
    @Config(description="Whether you can pet all mobs")
    public static boolean petAllMobs = false;
    @Config(description="If `petAllMobs` is set, these mobs still can't be pet")
    public static List<String> pettableDenylist = Lists.newArrayList((Object[])new String[]{"minecraft:ender_dragon", "minecraft:wither", "minecraft:armor_stand"});
    @Config(description="Even if `petAllMobs` is not set, these mobs can be pet")
    public static List<String> pettableAllowlist = Lists.newArrayList();

    @PlayEvent
    public void onWolfAppear(ZEntityJoinLevel event) {
        Entity entity;
        if (dogsWantLove > 0 && (entity = event.getEntity()) instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            boolean alreadySetUp = wolf.f_21345_.m_148105_().stream().anyMatch(goal -> goal.m_26015_() instanceof WantLoveGoal);
            if (!alreadySetUp) {
                MiscUtil.addGoalJustAfterLatestWithPriority((GoalSelector)wolf.f_21345_, (int)4, (Goal)new NuzzleGoal((TamableAnimal)wolf, 0.5, 16.0f, 2.0f, SoundEvents.f_12625_));
                MiscUtil.addGoalJustAfterLatestWithPriority((GoalSelector)wolf.f_21345_, (int)5, (Goal)new WantLoveGoal((TamableAnimal)wolf, 0.2f));
            }
        }
    }

    @PlayEvent
    public void onInteract(ZPlayerInteract.EntityInteract event) {
        Player player = event.getEntity();
        if (player.m_20163_() && player.m_21205_().m_41619_()) {
            Entity entity = event.getTarget();
            if (entity instanceof Wolf) {
                Wolf wolf = (Wolf)entity;
                if (event.getHand() == InteractionHand.MAIN_HAND && WantLoveGoal.canPet((TamableAnimal)wolf)) {
                    Level level = player.m_9236_();
                    if (level instanceof ServerLevel) {
                        serverLevel = (ServerLevel)level;
                        Vec3 pos = wolf.m_20182_();
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, pos.f_82479_, pos.f_82480_ + 0.5, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.1);
                        wolf.m_5496_(SoundEvents.f_12625_, 1.0f, 0.5f + (float)Math.random() * 0.5f);
                    } else {
                        player.m_6674_(InteractionHand.MAIN_HAND);
                    }
                    WantLoveGoal.setPetTime((TamableAnimal)wolf);
                    if (wolf instanceof Foxhound && !player.m_20069_() && !player.m_21023_(MobEffects.f_19607_) && !player.m_150110_().f_35934_) {
                        player.m_20254_(5);
                    }
                }
                event.setCanceled(true);
            } else {
                serverLevel = event.getTarget();
                if (serverLevel instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)serverLevel;
                    if ((petAllMobs || living instanceof Player || pettableAllowlist.contains(living.m_20078_())) && !pettableDenylist.contains(living.m_20078_())) {
                        Object uuid;
                        SoundEvent sound = null;
                        float pitchCenter = 1.0f;
                        if (living instanceof Axolotl) {
                            sound = SoundEvents.f_144066_;
                        } else if (living instanceof Cat || living instanceof Ocelot) {
                            sound = SoundEvents.f_11793_;
                        } else if (living instanceof Chicken) {
                            sound = SoundEvents.f_11750_;
                        } else if (living instanceof Cow) {
                            sound = SoundEvents.f_11830_;
                            pitchCenter = 1.2f;
                        } else if (living instanceof AbstractHorse) {
                            sound = SoundEvents.f_11971_;
                        } else if (living instanceof AbstractFish) {
                            sound = SoundEvents.f_11938_;
                        } else if (living instanceof Fox) {
                            sound = SoundEvents.f_11950_;
                        } else if (living instanceof Squid) {
                            sound = living instanceof GlowSquid ? SoundEvents.f_144162_ : SoundEvents.f_12441_;
                            pitchCenter = 1.2f;
                        } else if (living instanceof Parrot) {
                            sound = SoundEvents.f_12188_;
                        } else if (living instanceof Pig) {
                            sound = SoundEvents.f_12233_;
                        } else if (living instanceof Rabbit) {
                            sound = SoundEvents.f_12297_;
                        } else if (living instanceof Sheep) {
                            sound = SoundEvents.f_12341_;
                        } else if (living instanceof Strider) {
                            sound = SoundEvents.f_12459_;
                        } else if (living instanceof Turtle) {
                            sound = SoundEvents.f_12530_;
                        } else if (living instanceof Player) {
                            Player pettee = (Player)living;
                            switch (uuid = pettee.m_20149_()) {
                                case "a2ce9382-2518-4752-87b2-c6a5c97f173e": {
                                    SoundEvent soundEvent = QuarkSounds.PET_DEVICE;
                                    break;
                                }
                                case "29a10dc6-a201-4993-80d8-c847212bc92b": 
                                case "d30d8e38-6f93-4d96-968d-dd6ec5596941": {
                                    SoundEvent soundEvent = QuarkSounds.PET_NEKO;
                                    break;
                                }
                                case "d475af59-d73c-42be-90ed-f1a78f10d452": {
                                    SoundEvent soundEvent = QuarkSounds.PET_SLIME;
                                    break;
                                }
                                case "458391f5-6303-4649-b416-e4c0d18f837a": {
                                    SoundEvent soundEvent = QuarkSounds.PET_WIRE;
                                    break;
                                }
                                default: {
                                    SoundEvent soundEvent = sound = null;
                                }
                            }
                        }
                        if (sound != null) {
                            if (event.getHand() == InteractionHand.MAIN_HAND) {
                                uuid = player.m_9236_();
                                if (uuid instanceof ServerLevel) {
                                    ServerLevel serverLevel = (ServerLevel)uuid;
                                    Vec3 pos = living.m_146892_();
                                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, pos.f_82479_, pos.f_82480_ + 0.5, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.1);
                                    living.m_5496_(sound, 1.0f, pitchCenter + (float)(Math.random() - 0.5) * 0.5f);
                                } else {
                                    player.m_6674_(InteractionHand.MAIN_HAND);
                                }
                            }
                            event.setCanceled(true);
                        }
                    }
                }
            }
        }
    }

    @PlayEvent
    public void onTame(ZAnimalTame event) {
        Animal animal = event.getAnimal();
        if (animal instanceof Wolf) {
            Wolf wolf = (Wolf)animal;
            WantLoveGoal.setPetTime((TamableAnimal)wolf);
        }
    }
}

