/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.capability.v2.data;

import fuzs.puzzleslib.api.capability.v2.data.CapabilityComponent;
import fuzs.puzzleslib.api.capability.v2.data.CapabilityKey;
import fuzs.puzzleslib.api.capability.v2.data.SyncStrategy;
import fuzs.puzzleslib.api.capability.v2.data.SyncedCapabilityComponent;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.capability.v2.ClientboundSyncCapabilityMessage;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public interface PlayerCapabilityKey<C extends CapabilityComponent>
extends CapabilityKey<C> {
    public void syncToRemote(ServerPlayer var1);

    public static <C extends CapabilityComponent> void syncCapabilityToRemote(Entity holder, ServerPlayer receiver, SyncStrategy syncStrategy, C capability, ResourceLocation id, boolean force) {
        if (syncStrategy != SyncStrategy.MANUAL) {
            if (!(capability instanceof SyncedCapabilityComponent)) {
                if (!force) {
                    throw new IllegalStateException("Unable to sync capability component that is not of type %s".formatted(SyncedCapabilityComponent.class));
                }
                return;
            }
            SyncedCapabilityComponent syncedCapability = (SyncedCapabilityComponent)capability;
            if (force || syncedCapability.isDirty()) {
                syncStrategy.sendTo(new ClientboundSyncCapabilityMessage(id, holder, capability.toCompoundTag()), receiver);
                syncedCapability.markClean();
            }
        } else if (!force) {
            PuzzlesLib.LOGGER.warn("Attempting to sync capability {} that is set to manual syncing", (Object)id);
        }
    }
}

