/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.projectile;

import fuzs.mutantmonsters.init.ModRegistry;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MutantArrow
extends Arrow {
    private static final EntityDataAccessor<Integer> CLONES = SynchedEntityData.m_135353_(MutantArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public MutantArrow(EntityType<? extends MutantArrow> type, Level level) {
        super(type, level);
    }

    public MutantArrow(Level level, LivingEntity shooter) {
        this((EntityType<? extends MutantArrow>)((EntityType)ModRegistry.MUTANT_ARROW_ENTITY_TYPE.get()), level);
        this.m_6034_(shooter.m_20185_(), shooter.m_20188_() - (double)0.1f, shooter.m_20189_());
        this.m_20242_(true);
        this.m_5602_((Entity)shooter);
        this.m_36762_(true);
    }

    public void shoot(LivingEntity target, float velocity, float randomization) {
        Vec3 attackLocation = this.getAttackLocation(target, randomization);
        Vec3 attackVector = attackLocation.m_82546_(this.m_20182_());
        double horizontalDistance = attackVector.m_165924_();
        double x = attackVector.f_82479_;
        double y = attackVector.f_82480_;
        double z = attackVector.f_82481_;
        this.m_6686_(x, y, z, velocity, 0.0f);
        this.m_146922_(180.0f + (float)Math.toDegrees(Math.atan2(x, z)));
        while (this.m_146908_() > 360.0f) {
            this.m_146922_(this.m_146908_() - 360.0f);
        }
        this.m_146926_((float)Math.toDegrees(Math.atan2(y, horizontalDistance)));
    }

    private Vec3 getAttackLocation(LivingEntity target, float randomization) {
        double x = target.m_20185_() + (double)((this.f_19796_.m_188501_() - 0.5f) * randomization * 2.0f);
        double y = target.m_20227_(0.8) + (double)((this.f_19796_.m_188501_() - 0.5f) * randomization * 2.0f);
        double z = target.m_20189_() + (double)((this.f_19796_.m_188501_() - 0.5f) * randomization * 2.0f);
        return new Vec3(x, y, z);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLONES, (Object)1);
    }

    public int getClones() {
        return (Integer)this.f_19804_.m_135370_(CLONES);
    }

    public void setClones(int clones) {
        this.f_19804_.m_135381_(CLONES, (Object)clones);
    }

    public void m_8119_() {
        float xRot = this.m_146909_();
        float xRotO = this.f_19860_;
        float yRot = this.m_146908_();
        float yRotO = this.f_19859_;
        super.m_8119_();
        this.m_146926_(xRot);
        this.f_19860_ = xRotO;
        this.m_146922_(yRot);
        this.f_19859_ = yRotO;
        if (!this.m_213877_() && this.f_19797_ > 200) {
            this.m_146870_();
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (result.m_6662_() != HitResult.Type.MISS) {
            this.m_146870_();
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }

    protected void m_6901_() {
        this.m_146870_();
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 startVec, Vec3 endVec) {
        return ProjectileUtil.m_150175_((Level)this.m_9236_(), (Entity)this, (Vec3)startVec, (Vec3)endVec, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), x$0 -> this.m_5603_((Entity)x$0), (float)1.0f);
    }

    protected void m_7761_(LivingEntity target) {
        super.m_7761_(target);
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_11840_, this.m_5720_(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        }
    }
}

