/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MutantCreeperModel
extends EntityModel<MutantCreeper> {
    private final ModelPart pelvis;
    private final ModelPart body;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart frleg;
    private final ModelPart flleg;
    private final ModelPart frforeleg;
    private final ModelPart flforeleg;
    private final ModelPart brleg;
    private final ModelPart blleg;
    private final ModelPart brforeleg;
    private final ModelPart blforeleg;

    public MutantCreeperModel(ModelPart modelPart) {
        this.pelvis = modelPart.m_171324_("pelvis");
        this.body = this.pelvis.m_171324_("body");
        this.neck = this.body.m_171324_("neck");
        this.head = this.neck.m_171324_("head");
        this.frleg = this.pelvis.m_171324_("front_right_leg");
        this.flleg = this.pelvis.m_171324_("front_left_leg");
        this.frforeleg = this.frleg.m_171324_("front_right_fore_leg");
        this.flforeleg = this.flleg.m_171324_("front_left_fore_leg");
        this.brleg = this.pelvis.m_171324_("back_right_leg");
        this.blleg = this.pelvis.m_171324_("back_left_leg");
        this.brforeleg = this.brleg.m_171324_("back_right_fore_leg");
        this.blforeleg = this.blleg.m_171324_("back_left_fore_leg");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition pelvis = root.m_171599_("pelvis", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -14.0f, -4.0f, 10.0f, 14.0f, 8.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)-3.0f));
        PartDefinition body = pelvis.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(36, 0).m_171488_(-4.5f, -14.0f, -3.5f, 9.0f, 16.0f, 7.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(68, 0).m_171488_(-4.0f, -14.0f, -3.0f, 8.0f, 14.0f, 6.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)-11.0f, (float)1.0f));
        neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-5.0f, -12.0f, -5.0f, 10.0f, 12.0f, 10.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)1.0f));
        PartDefinition frontRightLeg = pelvis.m_171599_("front_right_leg", CubeListBuilder.m_171558_().m_171514_(40, 24).m_171488_(-3.0f, -4.0f, -14.0f, 6.0f, 4.0f, 14.0f, cubeDeformation), PartPose.m_171419_((float)3.0f, (float)0.0f, (float)0.0f));
        frontRightLeg.m_171599_("front_right_fore_leg", CubeListBuilder.m_171558_().m_171514_(96, 0).m_171488_(-3.5f, 0.0f, -4.0f, 7.0f, 20.0f, 8.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)-14.0f));
        PartDefinition frontLeftLeg = pelvis.m_171599_("front_left_leg", CubeListBuilder.m_171558_().m_171514_(40, 24).m_171480_().m_171488_(-3.0f, -4.0f, -14.0f, 6.0f, 4.0f, 14.0f, cubeDeformation), PartPose.m_171419_((float)-3.0f, (float)0.0f, (float)0.0f));
        frontLeftLeg.m_171599_("front_left_fore_leg", CubeListBuilder.m_171558_().m_171514_(96, 0).m_171480_().m_171488_(-3.5f, 0.0f, -4.0f, 7.0f, 20.0f, 8.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)-14.0f));
        PartDefinition backRightLeg = pelvis.m_171599_("back_right_leg", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171488_(-2.0f, -4.0f, 0.0f, 4.0f, 4.0f, 14.0f, cubeDeformation), PartPose.m_171419_((float)2.0f, (float)-2.0f, (float)4.0f));
        backRightLeg.m_171599_("back_right_fore_leg", CubeListBuilder.m_171558_().m_171514_(80, 28).m_171488_(-3.0f, 0.0f, -3.0f, 6.0f, 18.0f, 6.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)14.0f));
        PartDefinition backLeftLeg = pelvis.m_171599_("back_left_leg", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171480_().m_171488_(-2.0f, -4.0f, 0.0f, 4.0f, 4.0f, 14.0f, cubeDeformation), PartPose.m_171419_((float)-2.0f, (float)-2.0f, (float)4.0f));
        backLeftLeg.m_171599_("back_left_fore_leg", CubeListBuilder.m_171558_().m_171514_(80, 28).m_171480_().m_171488_(-3.0f, 0.0f, -3.0f, 6.0f, 18.0f, 6.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)14.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)64);
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.pelvis.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    public void setupAnim(MutantCreeper entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setAngles();
        this.animate(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    private void setAngles() {
        this.pelvis.f_104201_ = 14.0f;
        this.pelvis.f_104203_ = -0.7853982f;
        this.body.f_104203_ = 0.9424778f;
        this.body.f_104204_ = 0.0f;
        this.neck.f_104203_ = 1.0471976f;
        this.head.f_104203_ = 0.5235988f;
        this.frleg.f_104203_ = 0.31415927f;
        this.frleg.f_104204_ = -0.7853982f;
        this.frleg.f_104205_ = 0.0f;
        this.flleg.f_104203_ = 0.31415927f;
        this.flleg.f_104204_ = 0.7853982f;
        this.flleg.f_104205_ = 0.0f;
        this.frforeleg.f_104203_ = -0.20943952f;
        this.frforeleg.f_104204_ = 0.3926991f;
        this.flforeleg.f_104203_ = -0.20943952f;
        this.flforeleg.f_104204_ = -0.3926991f;
        this.brleg.f_104203_ = 0.9f;
        this.brleg.f_104204_ = 0.62831855f;
        this.brleg.f_104205_ = 0.0f;
        this.blleg.f_104203_ = 0.9f;
        this.blleg.f_104204_ = -0.62831855f;
        this.blleg.f_104205_ = 0.0f;
        this.brforeleg.f_104203_ = 0.48332196f;
        this.blforeleg.f_104203_ = 0.48332196f;
    }

    private void animate(MutantCreeper entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float breatheAnim = Mth.m_14031_((float)(ageInTicks * 0.1f));
        float walkAnim1 = (Mth.m_14031_((float)(limbSwing * (float)Math.PI / 4.0f)) + 0.4f) * limbSwingAmount;
        float walkAnim2 = (Mth.m_14031_((float)(limbSwing * (float)Math.PI / 4.0f + (float)Math.PI)) + 0.4f) * limbSwingAmount;
        if (walkAnim1 < 0.0f) {
            walkAnim1 = 0.0f;
        }
        if (walkAnim2 < 0.0f) {
            walkAnim2 = 0.0f;
        }
        float walkAnim3 = Mth.m_14031_((float)(limbSwing * (float)Math.PI / 8.0f)) * limbSwingAmount;
        float walkAnim4 = (Mth.m_14031_((float)(limbSwing * (float)Math.PI / 4.0f + 1.5707964f)) + 0.4f) * limbSwingAmount;
        float walkAnim5 = (Mth.m_14031_((float)(limbSwing * (float)Math.PI / 4.0f + 4.712389f)) + 0.4f) * limbSwingAmount;
        if (walkAnim4 < 0.0f) {
            walkAnim4 = 0.0f;
        }
        if (walkAnim5 < 0.0f) {
            walkAnim5 = 0.0f;
        }
        float walkAnim6 = Mth.m_14031_((float)(limbSwing * (float)Math.PI / 8.0f + 1.5707964f)) * limbSwingAmount;
        float faceYaw = netHeadYaw / 57.295776f;
        float facePitch = headPitch / 57.295776f;
        float f6 = faceYaw / 3.0f;
        float f7 = facePitch / 3.0f;
        this.pelvis.f_104201_ += Mth.m_14031_((float)(limbSwing * (float)Math.PI / 4.0f)) * limbSwingAmount * 0.5f;
        this.body.f_104203_ += breatheAnim * 0.02f;
        this.body.f_104203_ += f7;
        this.body.f_104204_ += f6;
        this.neck.f_104203_ += breatheAnim * 0.02f;
        this.neck.f_104203_ += f7;
        this.neck.f_104204_ = f6;
        this.head.f_104203_ += breatheAnim * 0.02f;
        this.head.f_104203_ += f7;
        this.head.f_104204_ = f6;
        this.frleg.f_104203_ -= walkAnim1 * 0.3f;
        this.frleg.f_104204_ += walkAnim3 * 0.2f;
        this.frleg.f_104205_ += walkAnim3 * 0.2f;
        this.flleg.f_104203_ -= walkAnim2 * 0.3f;
        this.flleg.f_104204_ -= walkAnim3 * 0.2f;
        this.flleg.f_104205_ -= walkAnim3 * 0.2f;
        this.brleg.f_104203_ += walkAnim5 * 0.3f;
        this.brleg.f_104204_ -= walkAnim6 * 0.2f;
        this.brleg.f_104205_ -= walkAnim6 * 0.2f;
        this.blleg.f_104203_ += walkAnim4 * 0.3f;
        this.blleg.f_104204_ += walkAnim6 * 0.2f;
        this.blleg.f_104205_ += walkAnim6 * 0.2f;
        if (this.f_102608_ > 0.0f) {
            float swingAnim = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI));
            this.body.f_104203_ += swingAnim * (float)Math.PI / 3.0f;
            this.neck.f_104203_ -= swingAnim * (float)Math.PI / 4.0f;
        }
    }
}

