/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.mixin.addlock;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import melonslise.locks.Locks;
import melonslise.locks.common.capability.ILockableHandler;
import melonslise.locks.common.config.LocksCommonConfig;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.util.Cuboid6i;
import melonslise.locks.common.util.Lock;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LockableInfo;
import melonslise.locks.common.util.LocksUtil;
import melonslise.locks.common.util.Transform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StructureTemplate.class})
public class StructureTemplateMixin {
    private final List<LockableInfo> lockableInfos = new ArrayList<LockableInfo>();
    @Unique
    private static final String KEY_LOCKABLES = "Lockables";

    @Inject(at={@At(value="HEAD")}, method={"fillFromWorld"})
    private void fillFromWorld(Level world, BlockPos start, Vec3i size, boolean takeEntities, @Nullable Block toIgnore, CallbackInfo ci) {
        if (size.m_123341_() >= 1 && size.m_123342_() >= 1 && size.m_123343_() >= 1) {
            this.lockableInfos.clear();
            ILockableHandler handler = (ILockableHandler)world.getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null);
            Cuboid6i bb = new Cuboid6i(start, start.m_7918_(size.m_123341_() - 1, size.m_123342_() - 1, size.m_123343_() - 1));
            handler.getLoaded().values().stream().filter(lkb -> lkb.bb.intersects(bb)).forEach(lkb -> {
                Cuboid6i newBB = bb.intersection(lkb.bb).offset(-start.m_123341_(), -start.m_123342_(), -start.m_123343_());
                this.lockableInfos.add(new LockableInfo(newBB, lkb.lock, lkb.tr, lkb.stack, lkb.id));
            });
        }
    }

    @Inject(at={@At(value="RETURN", ordinal=1)}, method={"placeInWorld"})
    private void placeInWorld(ServerLevelAccessor world, BlockPos start, BlockPos size, StructurePlaceSettings settings, RandomSource rng, int i, CallbackInfoReturnable<Boolean> cir) {
        ServerLevel level;
        try {
            level = world.m_6018_();
        }
        catch (Exception e) {
            Locks.LOGGER.warn(world + "#getLevel threw an error! Skipping lockable placement for this template ");
            return;
        }
        ILockableHandler handler = (ILockableHandler)level.getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null);
        for (LockableInfo lkb : this.lockableInfos) {
            BlockPos pos1 = LocksUtil.transform(lkb.bb.x1, lkb.bb.y1, lkb.bb.z1, settings);
            BlockPos pos2 = LocksUtil.transform(lkb.bb.x2, lkb.bb.y2, lkb.bb.z2, settings);
            Cuboid6i bb = new Cuboid6i(pos1.m_123341_() + start.m_123341_(), pos1.m_123342_() + start.m_123342_(), pos1.m_123343_() + start.m_123343_(), pos2.m_123341_() + start.m_123341_(), pos2.m_123342_() + start.m_123342_(), pos2.m_123343_() + start.m_123343_());
            ItemStack stack = (Boolean)LocksCommonConfig.RANDOMIZE_LOADED_LOCKS.get() != false ? LocksCommonConfig.getRandomLock(rng) : lkb.stack;
            Lock lock = (Boolean)LocksCommonConfig.RANDOMIZE_LOADED_LOCKS.get() != false ? Lock.from(stack) : lkb.lock;
            Transform tr = Transform.fromDirectionAndFace(settings.m_74404_().m_55954_(settings.m_74401_().m_54846_(lkb.tr.dir).m_55954_(lkb.tr.dir)), lkb.tr.face, Direction.NORTH);
            handler.add(new Lockable(bb, lock, tr, stack, (Level)level));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"save"})
    private void save(CompoundTag nbt, CallbackInfoReturnable<CompoundTag> cir) {
        ListTag list = new ListTag();
        for (LockableInfo lkb : this.lockableInfos) {
            list.add((Object)LockableInfo.toNbt(lkb));
        }
        nbt.m_128365_(KEY_LOCKABLES, (Tag)list);
    }

    @Inject(at={@At(value="HEAD")}, method={"load"})
    private void read(HolderGetter<Block> pBlockGetter, CompoundTag nbt, CallbackInfo ci) {
        this.lockableInfos.clear();
        ListTag list = nbt.m_128437_(KEY_LOCKABLES, 10);
        int b = list.size();
        for (int a = 0; a < b; ++a) {
            this.lockableInfos.add(LockableInfo.fromNbt(list.m_128728_(a)));
        }
    }
}

