/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.mixin;

import melonslise.locks.common.capability.ILockableHandler;
import melonslise.locks.common.capability.ILockableStorage;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.init.LocksNetwork;
import melonslise.locks.common.network.toclient.AddLockableToChunkPacket;
import melonslise.locks.common.util.ILockableProvider;
import melonslise.locks.common.util.Lockable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraftforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelChunk.class})
public class ChunkMixin {
    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/ProtoChunk;Lnet/minecraft/world/level/chunk/LevelChunk$PostLoadProcessor;)V"})
    private void init(ServerLevel world, ProtoChunk pChunk, LevelChunk.PostLoadProcessor pPostLoad, CallbackInfo ci) {
        LevelChunk ch = (LevelChunk)this;
        ILockableStorage st = (ILockableStorage)ch.getCapability(LocksCapabilities.LOCKABLE_STORAGE).orElse(null);
        ILockableHandler handler = (ILockableHandler)world.getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null);
        for (Lockable lkb : ((ILockableProvider)pChunk).getLockables()) {
            st.add(lkb);
            handler.getLoaded().put(lkb.id, (Object)lkb);
            lkb.addObserver(handler);
            LocksNetwork.MAIN.send(PacketDistributor.TRACKING_CHUNK.with(() -> ch), (Object)new AddLockableToChunkPacket(lkb, ch));
        }
    }
}

