/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Deque;
import java.util.Random;
import java.util.stream.Stream;
import melonslise.locks.common.config.LocksCommonConfig;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.util.Cuboid6i;
import melonslise.locks.common.util.ILockableProvider;
import melonslise.locks.common.util.Lock;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LocksPredicates;
import melonslise.locks.common.util.Transform;
import melonslise.locks.mixin.accessor.ForgeHooksAccessor;
import melonslise.locks.mixin.accessor.LootPoolAccessor;
import melonslise.locks.mixin.accessor.LootTableAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class LocksUtil {
    public static ResourceManager resourceManager;
    public static Constructor<?> lootTableContextConstructor;

    private LocksUtil() {
    }

    public static void shuffle(byte[] array, Random rng) {
        for (int a = array.length - 1; a > 0; --a) {
            int index = rng.nextInt(a + 1);
            byte temp = array[index];
            array[index] = array[a];
            array[a] = temp;
        }
    }

    public static boolean chance(RandomSource rng, double ch) {
        return ch == 1.0 || ch != 0.0 && rng.m_188500_() <= ch;
    }

    public static BlockPos transform(int x, int y, int z, StructurePlaceSettings settings) {
        switch (settings.m_74401_()) {
            case LEFT_RIGHT: {
                z = -z + 1;
                break;
            }
            case FRONT_BACK: {
                x = -x + 1;
                break;
            }
        }
        int x1 = settings.m_74407_().m_123341_();
        int z1 = settings.m_74407_().m_123343_();
        return switch (settings.m_74404_()) {
            case Rotation.COUNTERCLOCKWISE_90 -> new BlockPos(x1 - z1 + z, y, x1 + z1 - x + 1);
            case Rotation.CLOCKWISE_90 -> new BlockPos(x1 + z1 - z + 1, y, z1 - x1 + x);
            case Rotation.CLOCKWISE_180 -> new BlockPos(x1 + x1 - x + 1, y, z1 + z1 - z + 1);
            default -> new BlockPos(x, y, z);
        };
    }

    public static AttachFace faceFromDir(Direction dir) {
        return dir == Direction.UP ? AttachFace.CEILING : (dir == Direction.DOWN ? AttachFace.FLOOR : AttachFace.WALL);
    }

    public static AABB rotateY(AABB bb) {
        return new AABB(bb.f_82290_, bb.f_82289_, bb.f_82288_, bb.f_82293_, bb.f_82292_, bb.f_82291_);
    }

    public static AABB rotateX(AABB bb) {
        return new AABB(bb.f_82288_, bb.f_82290_, bb.f_82289_, bb.f_82291_, bb.f_82293_, bb.f_82292_);
    }

    public static boolean intersectsInclusive(AABB bb1, AABB bb2) {
        return bb1.f_82288_ <= bb2.f_82291_ && bb1.f_82291_ >= bb2.f_82288_ && bb1.f_82289_ <= bb2.f_82292_ && bb1.f_82292_ >= bb2.f_82289_ && bb1.f_82290_ <= bb2.f_82293_ && bb1.f_82293_ >= bb2.f_82290_;
    }

    public static Vec3 sideCenter(AABB bb, Direction side) {
        Vec3i dir = side.m_122436_();
        return new Vec3((bb.f_82288_ + bb.f_82291_ + (bb.f_82291_ - bb.f_82288_) * (double)dir.m_123341_()) * 0.5, (bb.f_82289_ + bb.f_82292_ + (bb.f_82292_ - bb.f_82289_) * (double)dir.m_123342_()) * 0.5, (bb.f_82290_ + bb.f_82293_ + (bb.f_82293_ - bb.f_82290_) * (double)dir.m_123343_()) * 0.5);
    }

    public static LootTable lootTableFrom(ResourceLocation loc) throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        JsonElement json = (JsonElement)GsonHelper.m_13776_((Gson)LootDataType.f_278413_.m_278857_(), (Reader)new BufferedReader(new InputStreamReader(((Resource)resourceManager.m_213713_(loc).orElseThrow()).m_215507_(), StandardCharsets.UTF_8)), JsonElement.class);
        Deque que = ForgeHooksAccessor.getLootContext().get();
        Object lootCtx = lootTableContextConstructor.newInstance(loc, false);
        try {
            que.push(lootCtx);
            LootTable lootTable = (LootTable)LootDataType.f_278413_.m_278857_().fromJson(json, LootTable.class);
            return lootTable;
        }
        catch (JsonSyntaxException e) {
            throw e;
        }
        finally {
            que.pop();
        }
    }

    public static LootTable mergeEntries(LootTable table, LootTable inject) {
        for (LootPool injectPool : ((LootTableAccessor)inject).getPools()) {
            LootPool pool = table.getPool(injectPool.getName());
            if (pool == null) {
                table.addPool(injectPool);
                continue;
            }
            ((LootPoolAccessor)pool).getEntries().addAll(((LootPoolAccessor)injectPool).getEntries());
        }
        return table;
    }

    public static Stream<Lockable> intersecting(Level world, BlockPos pos) {
        return (Stream)world.getCapability(LocksCapabilities.LOCKABLE_HANDLER).lazyMap(cap -> cap.getInChunk(pos).values().stream().filter(lkb -> lkb.bb.intersects(pos))).orElse(Stream.empty());
    }

    public static boolean lockedAndRelated(Level world, BlockPos pos) {
        BlockPos above = pos.m_7494_();
        Block aboveBlock = world.m_8055_(above).m_60734_();
        boolean checkAbove = LocksUtil.locked(world, above) && aboveBlock instanceof DoorBlock;
        return LocksUtil.locked(world, pos) || checkAbove;
    }

    public static boolean locked(Level world, BlockPos pos) {
        return LocksUtil.intersecting(world, pos).anyMatch(LocksPredicates.LOCKED);
    }

    public static Lockable lockWhenGen(LevelAccessor levelAccessor, ServerLevel level, BlockPos blockPos, RandomSource randomSource) {
        BlockState state = levelAccessor.m_8055_(blockPos);
        Block block = state.m_60734_();
        if (!LocksCommonConfig.canGen(randomSource, block)) {
            return null;
        }
        BlockPos pos1 = blockPos;
        Direction dir = state.m_61138_((Property)BlockStateProperties.f_61372_) ? (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_) : (state.m_61138_((Property)BlockStateProperties.f_61374_) ? (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_) : Direction.DOWN);
        if (state.m_61138_((Property)BlockStateProperties.f_61392_)) {
            switch ((ChestType)state.m_61143_((Property)BlockStateProperties.f_61392_)) {
                case LEFT: {
                    pos1 = blockPos.m_121945_(ChestBlock.m_51584_((BlockState)state));
                    break;
                }
                case RIGHT: {
                    return null;
                }
            }
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61401_)) {
            if (state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER) {
                return null;
            }
            pos1 = blockPos.m_7495_();
            if (state.m_61138_((Property)BlockStateProperties.f_61394_)) {
                BlockPos pos2;
                if (state.m_61138_((Property)BlockStateProperties.f_61394_) && state.m_61138_((Property)BlockStateProperties.f_61374_) && levelAccessor.m_8055_(pos2 = pos1.m_121945_(state.m_61143_((Property)BlockStateProperties.f_61394_) == DoorHingeSide.LEFT ? dir.m_122427_() : dir.m_122428_())).m_60713_(state.m_60734_())) {
                    if (state.m_61143_((Property)BlockStateProperties.f_61394_) == DoorHingeSide.LEFT) {
                        return null;
                    }
                    pos1 = pos2;
                }
                dir = dir.m_122424_();
            }
        }
        Cuboid6i bb = new Cuboid6i(blockPos, pos1);
        ItemStack stack = LocksCommonConfig.getRandomLock(randomSource);
        Lock lock = Lock.from(stack);
        Transform tr = Transform.fromDirection(dir, dir);
        if (tr == null) {
            tr = Transform.NORTH_UP;
        }
        return new Lockable(bb, lock, tr, stack, (Level)level);
    }

    public static Lockable lockCheck(LevelAccessor levelAccessor, ServerLevel level, BlockPos blockPos, RandomSource randomSource) {
        if (levelAccessor.m_7232_(blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4)) {
            return LocksUtil.lockWhenGen(levelAccessor, level, blockPos, randomSource);
        }
        return null;
    }

    public static boolean lockChunk(LevelAccessor levelAccessor, ServerLevel level, BlockPos blockPos, RandomSource randomSource, ChunkAccess chunkAccess) {
        Lockable lkb = LocksUtil.lockCheck(levelAccessor, level, blockPos, randomSource);
        if (lkb == null) {
            return false;
        }
        ((ILockableProvider)chunkAccess).getLockables().add(lkb);
        return true;
    }

    public static boolean lockChunk(LevelAccessor levelAccessor, ServerLevel level, BlockPos blockPos, RandomSource randomSource) {
        Lockable lkb = LocksUtil.lockCheck(levelAccessor, level, blockPos, randomSource);
        if (lkb == null) {
            return false;
        }
        lkb.bb.getContainedChunks((x, z) -> {
            ((ILockableProvider)levelAccessor.m_6325_(x, z)).getLockables().add(lkb);
            return true;
        });
        return true;
    }

    static {
        try {
            lootTableContextConstructor = Class.forName("net.minecraftforge.common.ForgeHooks$LootTableContext").getDeclaredConstructor(ResourceLocation.class, Boolean.TYPE);
            lootTableContextConstructor.setAccessible(true);
        }
        catch (ClassNotFoundException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
    }
}

