/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import melonslise.locks.common.capability.ILockableHandler;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.item.LockItem;
import melonslise.locks.common.util.Cuboid6i;
import melonslise.locks.common.util.Lock;
import melonslise.locks.common.util.LocksUtil;
import melonslise.locks.common.util.Transform;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Lockable
extends Observable
implements Observer {
    public final Cuboid6i bb;
    public final Lock lock;
    public final Transform tr;
    public final ItemStack stack;
    public final int id;
    public int oldSwingTicks;
    public int swingTicks;
    public int maxSwingTicks;
    public Map<List<BlockState>, State> cache = new HashMap<List<BlockState>, State>(6);
    public static final String KEY_BB = "Bb";
    public static final String KEY_LOCK = "Lock";
    public static final String KEY_TRANSFORM = "Transform";
    public static final String KEY_STACK = "Stack";
    public static final String KEY_ID = "Id";

    public Lockable(Cuboid6i bb, Lock lock, Transform tr, ItemStack stack, Level world) {
        this(bb, lock, tr, stack, ((ILockableHandler)world.getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null)).nextId());
    }

    public Lockable(Cuboid6i bb, Lock lock, Transform tr, ItemStack stack, int id) {
        this.bb = bb;
        this.lock = lock;
        this.tr = tr;
        this.stack = stack;
        this.id = id;
        lock.addObserver(this);
    }

    public static Lockable fromNbt(CompoundTag nbt) {
        return new Lockable(Cuboid6i.fromNbt(nbt.m_128469_(KEY_BB)), Lock.fromNbt(nbt.m_128469_(KEY_LOCK)), Transform.values()[nbt.m_128445_(KEY_TRANSFORM)], ItemStack.m_41712_((CompoundTag)nbt.m_128469_(KEY_STACK)), nbt.m_128451_(KEY_ID));
    }

    public static CompoundTag toNbt(Lockable lkb) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_(KEY_BB, (Tag)Cuboid6i.toNbt(lkb.bb));
        nbt.m_128365_(KEY_LOCK, (Tag)Lock.toNbt(lkb.lock));
        nbt.m_128344_(KEY_TRANSFORM, (byte)lkb.tr.ordinal());
        nbt.m_128365_(KEY_STACK, (Tag)lkb.stack.serializeNBT());
        nbt.m_128405_(KEY_ID, lkb.id);
        return nbt;
    }

    public static int idFromNbt(CompoundTag nbt) {
        return nbt.m_128451_(KEY_ID);
    }

    public static Lockable fromBuf(FriendlyByteBuf buf) {
        return new Lockable(Cuboid6i.fromBuf(buf), Lock.fromBuf(buf), (Transform)buf.m_130066_(Transform.class), buf.m_130267_(), buf.readInt());
    }

    public static void toBuf(FriendlyByteBuf buf, Lockable lkb) {
        Cuboid6i.toBuf(buf, lkb.bb);
        Lock.toBuf(buf, lkb.lock);
        buf.m_130068_((Enum)lkb.tr);
        buf.m_130055_(lkb.stack);
        buf.writeInt(lkb.id);
    }

    @Override
    public void update(Observable lock, Object data) {
        this.setChanged();
        this.notifyObservers();
        LockItem.setOpen(this.stack, !this.lock.locked);
    }

    public void tick() {
        this.oldSwingTicks = this.swingTicks;
        if (this.swingTicks > 0) {
            --this.swingTicks;
        }
    }

    public void swing(int ticks) {
        this.oldSwingTicks = this.maxSwingTicks = ticks;
        this.swingTicks = this.maxSwingTicks;
    }

    public State getLockState(Level world) {
        Vec3 center;
        ArrayList<BlockState> states = new ArrayList<BlockState>(this.bb.volume());
        for (BlockPos pos : this.bb.getContainedPos()) {
            if (!world.m_46805_(pos)) {
                return null;
            }
            states.add(world.m_8055_(pos));
        }
        State state = this.cache.get(states);
        if (state != null) {
            return state;
        }
        ArrayList<AABB> boxes = new ArrayList<AABB>(4);
        for (BlockPos pos : this.bb.getContainedPos()) {
            VoxelShape shape = world.m_8055_(pos).m_60808_((BlockGetter)world, pos);
            if (shape.m_83281_()) continue;
            AABB bb = shape.m_83215_();
            AABB union = bb = bb.m_82338_(pos);
            Iterator it = boxes.iterator();
            while (it.hasNext()) {
                AABB bb1 = (AABB)it.next();
                if (!LocksUtil.intersectsInclusive(union, bb1)) continue;
                union = union.m_82367_(bb1);
                it.remove();
            }
            boxes.add(union);
        }
        if (boxes.isEmpty()) {
            return null;
        }
        Direction side = this.tr.getCuboidFace();
        Vec3 point = center = this.bb.sideCenter(side);
        double min = -1.0;
        for (AABB box : boxes) {
            for (Direction side1 : Direction.values()) {
                Vec3 point1 = LocksUtil.sideCenter(box, side1).m_82549_(Vec3.m_82528_((Vec3i)side1.m_122436_()).m_82490_(0.05));
                double dist = center.m_82557_(point1);
                if (min != -1.0 && dist >= min) continue;
                point = point1;
                min = dist;
                side = side1;
            }
        }
        state = new State(point, Transform.fromDirection(side, this.tr.dir));
        this.cache.put(states, state);
        return state;
    }

    public static class State {
        public static final AABB VERT_Z_BB = new AABB(-0.125, -0.1875, 0.03125, 0.125, 0.1875, 0.03125);
        public static final AABB VERT_X_BB = LocksUtil.rotateY(VERT_Z_BB);
        public static final AABB HOR_Z_BB = LocksUtil.rotateX(VERT_Z_BB);
        public static final AABB HOR_X_BB = LocksUtil.rotateY(HOR_Z_BB);
        public final Vec3 pos;
        public final Transform tr;
        public final AABB bb;

        public static AABB getBounds(Transform tr) {
            return tr.face == AttachFace.WALL ? (tr.dir.m_122434_() == Direction.Axis.Z ? VERT_Z_BB : VERT_X_BB) : (tr.dir.m_122434_() == Direction.Axis.Z ? HOR_Z_BB : HOR_X_BB);
        }

        public State(Vec3 pos, Transform tr) {
            this(pos, tr, State.getBounds(tr).m_82383_(pos));
        }

        public State(Vec3 pos, Transform tr, AABB bb) {
            this.pos = pos;
            this.tr = tr;
            this.bb = bb;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean inView(Frustum ch) {
            AABB aabb = new AABB(this.bb.f_82288_, this.bb.f_82289_, this.bb.f_82290_, this.bb.f_82291_, this.bb.f_82292_, this.bb.f_82293_);
            return ch.m_113029_(aabb);
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean inRange(Vec3 pos) {
            double max;
            Minecraft mc = Minecraft.m_91087_();
            double dist = this.pos.m_82557_(pos);
            return dist < (max = (double)((Integer)mc.f_91066_.m_231984_().m_231551_() * 8)) * max;
        }
    }
}

