/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import melonslise.locks.common.util.BiIntFunction;
import melonslise.locks.common.util.BiIntPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Cuboid6i {
    public final int x1;
    public final int y1;
    public final int z1;
    public final int x2;
    public final int y2;
    public final int z2;
    public static final String KEY_X1 = "X1";
    public static final String KEY_Y1 = "Y1";
    public static final String KEY_Z1 = "Z1";
    public static final String KEY_X2 = "X2";
    public static final String KEY_Y2 = "Y2";
    public static final String KEY_Z2 = "Z2";

    public Cuboid6i(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.x1 = Math.min(x1, x2);
        this.y1 = Math.min(y1, y2);
        this.z1 = Math.min(z1, z2);
        this.x2 = Math.max(x1, x2);
        this.y2 = Math.max(y1, y2);
        this.z2 = Math.max(z1, z2);
    }

    public Cuboid6i(BlockPos pos1, BlockPos pos2) {
        this.x1 = Math.min(pos1.m_123341_(), pos2.m_123341_());
        this.y1 = Math.min(pos1.m_123342_(), pos2.m_123342_());
        this.z1 = Math.min(pos1.m_123343_(), pos2.m_123343_());
        this.x2 = Math.max(pos1.m_123341_(), pos2.m_123341_()) + 1;
        this.y2 = Math.max(pos1.m_123342_(), pos2.m_123342_()) + 1;
        this.z2 = Math.max(pos1.m_123343_(), pos2.m_123343_()) + 1;
    }

    public static Cuboid6i fromNbt(CompoundTag nbt) {
        return new Cuboid6i(nbt.m_128451_(KEY_X1), nbt.m_128451_(KEY_Y1), nbt.m_128451_(KEY_Z1), nbt.m_128451_(KEY_X2), nbt.m_128451_(KEY_Y2), nbt.m_128451_(KEY_Z2));
    }

    public static CompoundTag toNbt(Cuboid6i bb) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(KEY_X1, bb.x1);
        nbt.m_128405_(KEY_Y1, bb.y1);
        nbt.m_128405_(KEY_Z1, bb.z1);
        nbt.m_128405_(KEY_X2, bb.x2);
        nbt.m_128405_(KEY_Y2, bb.y2);
        nbt.m_128405_(KEY_Z2, bb.z2);
        return nbt;
    }

    public static Cuboid6i fromBuf(FriendlyByteBuf buf) {
        return new Cuboid6i(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void toBuf(FriendlyByteBuf buf, Cuboid6i bb) {
        buf.writeInt(bb.x1);
        buf.writeInt(bb.y1);
        buf.writeInt(bb.z1);
        buf.writeInt(bb.x2);
        buf.writeInt(bb.y2);
        buf.writeInt(bb.z2);
    }

    public Cuboid6i offset(int x, int y, int z) {
        return new Cuboid6i(this.x1 + x, this.y1 + y, this.z1 + z, this.x2 + x, this.y2 + y, this.z2 + z);
    }

    public Cuboid6i intersection(Cuboid6i other) {
        return new Cuboid6i(Math.max(this.x1, other.x1), Math.max(this.y1, other.y1), Math.max(this.z1, other.z1), Math.min(this.x2, other.x2), Math.min(this.y2, other.y2), Math.min(this.z2, other.z2));
    }

    public int length() {
        return this.x2 - this.x1;
    }

    public int height() {
        return this.y2 - this.y1;
    }

    public int width() {
        return this.z2 - this.z1;
    }

    public int volume() {
        return this.length() * this.height() * this.width();
    }

    public Vec3 center() {
        return new Vec3((double)(this.x1 + this.x2) * 0.5, (double)(this.y1 + this.y2) * 0.5, (double)(this.z1 + this.z2) * 0.5);
    }

    public boolean intersects(int x1, int y1, int z1, int x2, int y2, int z2) {
        return this.x1 < x2 && this.x2 > x1 && this.y1 < y2 && this.y2 > y1 && this.z1 < z2 && this.z2 > z1;
    }

    public boolean intersects(Cuboid6i other) {
        return this.intersects(other.x1, other.y1, other.z1, other.x2, other.y2, other.z2);
    }

    public boolean intersects(BlockPos pos) {
        return this.intersects(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), pos.m_123341_() + 1, pos.m_123342_() + 1, pos.m_123343_() + 1);
    }

    public Iterable<BlockPos> getContainedPos() {
        return BlockPos.m_121976_((int)this.x1, (int)this.y1, (int)this.z1, (int)(this.x2 - 1), (int)(this.y2 - 1), (int)(this.z2 - 1));
    }

    public boolean getContainedChunks(BiIntPredicate p) {
        int x1 = this.x1 >> 4;
        int x2 = this.x2 >> 4;
        int z1 = this.z1 >> 4;
        int z2 = this.z2 >> 4;
        if (this.x2 % 16 == 0) {
            --x2;
        }
        if (this.z2 % 16 == 0) {
            --z2;
        }
        int sizeX = x2 - x1 + 1;
        int length = sizeX * (z2 - z1 + 1);
        for (int a = 0; a < length; ++a) {
            if (!p.test(x1 + a / sizeX, z1 + a % sizeX)) continue;
            return false;
        }
        return true;
    }

    public <T> List<T> containedChunksTo(BiIntFunction<T> f, boolean endEarly) {
        int x1 = this.x1 >> 4;
        int x2 = this.x2 >> 4;
        int z1 = this.z1 >> 4;
        int z2 = this.z2 >> 4;
        if (this.x2 % 16 == 0) {
            --x2;
        }
        if (this.z2 % 16 == 0) {
            --z2;
        }
        int sizeX = x2 - x1 + 1;
        int length = sizeX * (z2 - z1 + 1);
        ArrayList<T> list = new ArrayList<T>(length);
        for (int a = 0; a < length; ++a) {
            T t = f.apply(x1 + a % sizeX, z1 + a / sizeX);
            if (endEarly && t == null) {
                return null;
            }
            list.add(a, t);
        }
        return list;
    }

    public Vec3 sideCenter(Direction side) {
        Vec3i dir = side.m_122436_();
        return new Vec3((double)(this.x1 + this.x2 + this.length() * dir.m_123341_()) * 0.5, (double)(this.y1 + this.y2 + this.height() * dir.m_123342_()) * 0.5, (double)(this.z1 + this.z2 + this.width() * dir.m_123343_()) * 0.5);
    }

    public boolean isLoaded(Level world) {
        return world.m_46812_(this.x1, this.y1, this.z1, this.x2, this.y2, this.z2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Cuboid6i)) {
            return false;
        }
        Cuboid6i box = (Cuboid6i)object;
        return this.x1 == box.x1 && this.x2 == box.x2 && this.y1 == box.y1 && this.y2 == box.y2 && this.z1 == box.z1 && this.z2 == box.z2;
    }

    public int hashCode() {
        return Objects.hash(this.x1, this.y1, this.z1, this.x2, this.y2, this.z2);
    }

    public String toString() {
        return "Box{" + this.x1 + ", " + this.y1 + ", " + this.z1 + ", " + this.x2 + ", " + this.y2 + ", " + this.z2 + "}";
    }
}

