/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.network.toclient;

import java.util.function.Supplier;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.util.Lockable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class UpdateLockablePacket {
    private final int id;
    private final boolean locked;

    public UpdateLockablePacket(int id, boolean locked) {
        this.id = id;
        this.locked = locked;
    }

    public UpdateLockablePacket(Lockable lkb) {
        this(lkb.id, lkb.lock.isLocked());
    }

    public static UpdateLockablePacket decode(FriendlyByteBuf buf) {
        return new UpdateLockablePacket(buf.readInt(), buf.readBoolean());
    }

    public static void encode(UpdateLockablePacket pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.id);
        buf.writeBoolean(pkt.locked);
    }

    public static void handle(final UpdateLockablePacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                Minecraft.m_91087_().f_91073_.getCapability(LocksCapabilities.LOCKABLE_HANDLER).ifPresent(handler -> ((Lockable)handler.getLoaded().get((int)pkt2.id)).lock.setLocked(pkt2.locked));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

