/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.network.toclient;

import java.util.function.Supplier;
import melonslise.locks.common.container.LockPickingContainer;
import melonslise.locks.common.init.LocksContainerTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class TryPinResultPacket {
    private final boolean correct;
    private final boolean reset;

    public TryPinResultPacket(boolean correct, boolean reset) {
        this.correct = correct;
        this.reset = reset;
    }

    public static TryPinResultPacket decode(FriendlyByteBuf buf) {
        return new TryPinResultPacket(buf.readBoolean(), buf.readBoolean());
    }

    public static void encode(TryPinResultPacket pkt, FriendlyByteBuf buf) {
        buf.writeBoolean(pkt.correct);
        buf.writeBoolean(pkt.reset);
    }

    public static void handle(final TryPinResultPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                AbstractContainerMenu container = Minecraft.m_91087_().f_91074_.f_36096_;
                if (container.m_6772_() == LocksContainerTypes.LOCK_PICKING.get()) {
                    ((LockPickingContainer)container).handlePin(pkt.correct, pkt.reset);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

