/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.network.toclient;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.function.Supplier;
import melonslise.locks.common.capability.ILockableHandler;
import melonslise.locks.common.capability.ILockableStorage;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.util.Lockable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkEvent;

public class AddLockableToChunkPacket {
    private final Lockable lockable;
    private final int x;
    private final int z;

    public AddLockableToChunkPacket(Lockable lkb, int x, int z) {
        this.lockable = lkb;
        this.x = x;
        this.z = z;
    }

    public AddLockableToChunkPacket(Lockable lkb, ChunkPos pos) {
        this(lkb, pos.f_45578_, pos.f_45579_);
    }

    public AddLockableToChunkPacket(Lockable lkb, LevelChunk ch) {
        this(lkb, ch.m_7697_());
    }

    public static AddLockableToChunkPacket decode(FriendlyByteBuf buf) {
        return new AddLockableToChunkPacket(Lockable.fromBuf(buf), buf.readInt(), buf.readInt());
    }

    public static void encode(AddLockableToChunkPacket pkt, FriendlyByteBuf buf) {
        Lockable.toBuf(buf, pkt.lockable);
        buf.writeInt(pkt.x);
        buf.writeInt(pkt.z);
    }

    public static void handle(final AddLockableToChunkPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                Minecraft mc = Minecraft.m_91087_();
                ILockableStorage st = (ILockableStorage)mc.f_91073_.m_6325_(pkt.x, pkt.z).getCapability(LocksCapabilities.LOCKABLE_STORAGE).orElse(null);
                ILockableHandler handler = (ILockableHandler)mc.f_91073_.getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null);
                Int2ObjectMap<Lockable> lkbs = handler.getLoaded();
                Lockable lkb = (Lockable)lkbs.get(pkt.lockable.id);
                if (lkb == lkbs.defaultReturnValue()) {
                    lkb = pkt.lockable;
                    lkb.addObserver(handler);
                    lkbs.put(lkb.id, (Object)lkb);
                }
                st.add(lkb);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

