/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.item;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import melonslise.locks.common.container.LockPickingContainer;
import melonslise.locks.common.init.LocksEnchantments;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LocksPredicates;
import melonslise.locks.common.util.LocksUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class LockPickItem
extends Item {
    public static final Component TOO_COMPLEX_MESSAGE = Component.m_237115_((String)"locks.status.too_complex");
    public final float strength;
    public static final String KEY_STRENGTH = "Strength";

    public LockPickItem(float strength, Item.Properties props) {
        super(props);
        this.strength = strength;
    }

    public static float getOrSetStrength(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128441_(KEY_STRENGTH)) {
            nbt.m_128350_(KEY_STRENGTH, ((LockPickItem)stack.m_41720_()).strength);
        }
        return nbt.m_128457_(KEY_STRENGTH);
    }

    public static boolean canPick(ItemStack stack, int cmp) {
        return LockPickItem.getOrSetStrength(stack) > (float)cmp * 0.25f;
    }

    public static boolean canPick(ItemStack stack, Lockable lkb) {
        return LockPickItem.canPick(stack, EnchantmentHelper.m_44843_((Enchantment)((Enchantment)LocksEnchantments.COMPLEXITY.get()), (ItemStack)lkb.stack));
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Level world = ctx.m_43725_();
        Player player = ctx.m_43723_();
        BlockPos pos = ctx.m_8083_();
        List match = LocksUtil.intersecting(world, pos).filter(LocksPredicates.LOCKED).collect(Collectors.toList());
        if (match.isEmpty()) {
            return InteractionResult.PASS;
        }
        Lockable lkb = (Lockable)match.get(0);
        if (!LockPickItem.canPick(ctx.m_43722_(), lkb)) {
            if (world.f_46443_) {
                player.m_5661_(TOO_COMPLEX_MESSAGE, true);
            }
            return InteractionResult.PASS;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        InteractionHand hand = ctx.m_43724_();
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new LockPickingContainer.Provider(hand, lkb), (Consumer)new LockPickingContainer.Writer(hand, lkb));
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> lines, TooltipFlag flag) {
        super.m_7373_(stack, world, lines, flag);
        lines.add((Component)Component.m_237110_((String)"locks.tooltip.strength", (Object[])new Object[]{ItemStack.f_41584_.format(stack.m_41782_() && stack.m_41783_().m_128441_(KEY_STRENGTH) ? (double)stack.m_41783_().m_128457_(KEY_STRENGTH) : (double)this.strength)}).m_130940_(ChatFormatting.DARK_GREEN));
    }
}

