/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.item;

import java.util.List;
import melonslise.locks.common.capability.ILockableHandler;
import melonslise.locks.common.capability.ISelection;
import melonslise.locks.common.config.LocksServerConfig;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.init.LocksSoundEvents;
import melonslise.locks.common.item.LockingItem;
import melonslise.locks.common.util.Cuboid6i;
import melonslise.locks.common.util.Lock;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.Transform;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LockItem
extends LockingItem {
    public final int length;
    public final int enchantmentValue;
    public final int resistance;
    public static final String KEY_OPEN = "Open";
    public static final String KEY_LENGTH = "Length";

    public LockItem(int length, int enchVal, int resist, Item.Properties props) {
        super(props);
        this.length = length;
        this.enchantmentValue = enchVal;
        this.resistance = resist;
    }

    public static boolean isOpen(ItemStack stack) {
        return stack.m_41784_().m_128471_(KEY_OPEN);
    }

    public static void setOpen(ItemStack stack, boolean open) {
        stack.m_41784_().m_128379_(KEY_OPEN, open);
    }

    public static byte getOrSetLength(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128441_(KEY_LENGTH)) {
            nbt.m_128344_(KEY_LENGTH, (byte)((LockItem)stack.m_41720_()).length);
        }
        return nbt.m_128445_(KEY_LENGTH);
    }

    public static int getResistance(ItemStack stack) {
        return ((LockItem)stack.m_41720_()).resistance;
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockPos pos;
        Level world = ctx.m_43725_();
        if (!LocksServerConfig.canLock(world, pos = ctx.m_8083_()) || ((ILockableHandler)ctx.m_43725_().getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null)).getInChunk(pos).values().stream().anyMatch(lkb -> lkb.bb.intersects(pos))) {
            return InteractionResult.PASS;
        }
        return (Boolean)LocksServerConfig.EASY_LOCK.get() != false ? this.easyLock(ctx) : this.freeLock(ctx);
    }

    public InteractionResult freeLock(UseOnContext ctx) {
        Player player = ctx.m_43723_();
        BlockPos pos = ctx.m_8083_();
        ISelection select = (ISelection)player.getCapability(LocksCapabilities.SELECTION).orElse(null);
        BlockPos pos1 = select.get();
        if (pos1 == null) {
            select.set(pos);
        } else {
            Level world = ctx.m_43725_();
            select.set(null);
            world.m_5594_(player, pos, (SoundEvent)LocksSoundEvents.LOCK_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            ItemStack stack = ctx.m_43722_();
            ItemStack lockStack = stack.m_41777_();
            lockStack.m_41764_(1);
            ILockableHandler handler = (ILockableHandler)world.getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null);
            if (!handler.add(new Lockable(new Cuboid6i(pos1, pos), Lock.from(stack), Transform.fromDirection(ctx.m_43719_(), player.m_6350_().m_122424_()), lockStack, world))) {
                return InteractionResult.PASS;
            }
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult easyLock(UseOnContext ctx) {
        Player player = ctx.m_43723_();
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        world.m_5594_(player, pos, (SoundEvent)LocksSoundEvents.LOCK_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockState state = world.m_8055_(pos);
        BlockPos pos1 = pos;
        if (state.m_61138_((Property)BlockStateProperties.f_61392_) && state.m_61143_((Property)BlockStateProperties.f_61392_) != ChestType.SINGLE) {
            pos1 = pos.m_121945_(ChestBlock.m_51584_((BlockState)state));
        } else if (state.m_61138_((Property)BlockStateProperties.f_61401_)) {
            BlockPos blockPos = pos1 = state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_();
            if (state.m_61138_((Property)BlockStateProperties.f_61394_) && state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
                BlockPos pos2 = pos1.m_121945_(state.m_61143_((Property)BlockStateProperties.f_61394_) == DoorHingeSide.LEFT ? dir.m_122427_() : dir.m_122428_());
                if (world.m_8055_(pos2).m_60713_(state.m_60734_())) {
                    pos1 = pos2;
                }
            }
        }
        ItemStack stack = ctx.m_43722_();
        ItemStack lockStack = stack.m_41777_();
        lockStack.m_41764_(1);
        ILockableHandler handler = (ILockableHandler)world.getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null);
        if (!handler.add(new Lockable(new Cuboid6i(pos, pos1), Lock.from(stack), Transform.fromDirection(ctx.m_43719_(), player.m_6350_().m_122424_()), lockStack, world))) {
            return InteractionResult.PASS;
        }
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!LockItem.isOpen(stack)) {
            return super.m_7203_(world, player, hand);
        }
        LockItem.setOpen(stack, false);
        world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)LocksSoundEvents.PIN_MATCH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        return super.m_7203_(world, player, hand);
    }

    public boolean m_8120_(ItemStack p_77616_1_) {
        return true;
    }

    public int m_6473_() {
        return this.enchantmentValue;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> lines, TooltipFlag flag) {
        super.m_7373_(stack, world, lines, flag);
        lines.add((Component)Component.m_237110_((String)"locks.tooltip.length", (Object[])new Object[]{ItemStack.f_41584_.format(stack.m_41782_() && stack.m_41783_().m_128441_(KEY_LENGTH) ? (long)stack.m_41783_().m_128445_(KEY_LENGTH) : (long)this.length)}).m_130940_(ChatFormatting.DARK_GREEN));
    }
}

