/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.item;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import melonslise.locks.common.capability.CapabilityProvider;
import melonslise.locks.common.capability.KeyRingInventory;
import melonslise.locks.common.container.KeyRingContainer;
import melonslise.locks.common.init.LocksSoundEvents;
import melonslise.locks.common.item.LockingItem;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LocksUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;

public class KeyRingItem
extends Item {
    public final int rows;

    public KeyRingItem(int rows, Item.Properties props) {
        super(props.m_41487_(1));
        this.rows = rows;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new CapabilityProvider<KeyRingInventory>(ForgeCapabilities.ITEM_HANDLER, new KeyRingInventory(stack, this.rows, 9));
    }

    public static boolean containsId(ItemStack stack, int id) {
        IItemHandler inv = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        for (int a = 0; a < inv.getSlots(); ++a) {
            if (LockingItem.getOrSetId(inv.getStackInSlot(a)) != id) continue;
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_9236_().f_46443_) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new KeyRingContainer.Provider(stack), (Consumer)new KeyRingContainer.Writer(hand));
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        IItemHandler inv = (IItemHandler)ctx.m_43722_().getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        List intersect = LocksUtil.intersecting(world, pos).collect(Collectors.toList());
        if (intersect.isEmpty()) {
            return InteractionResult.PASS;
        }
        for (int a = 0; a < inv.getSlots(); ++a) {
            int id = LockingItem.getOrSetId(inv.getStackInSlot(a));
            List match = intersect.stream().filter(lkb -> lkb.lock.id == id).collect(Collectors.toList());
            if (match.isEmpty()) continue;
            world.m_5594_(ctx.m_43723_(), pos, (SoundEvent)LocksSoundEvents.LOCK_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            for (Lockable lkb2 : match) {
                lkb2.lock.setLocked(!lkb2.lock.isLocked());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }
}

