/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.event;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import melonslise.locks.common.capability.ILockableHandler;
import melonslise.locks.common.capability.ILockableStorage;
import melonslise.locks.common.capability.ISelection;
import melonslise.locks.common.config.LocksClientConfig;
import melonslise.locks.common.config.LocksServerConfig;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.init.LocksItemTags;
import melonslise.locks.common.init.LocksItems;
import melonslise.locks.common.init.LocksSoundEvents;
import melonslise.locks.common.item.KeyRingItem;
import melonslise.locks.common.item.LockingItem;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LocksPredicates;
import melonslise.locks.common.util.LocksUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="locks", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class LocksForgeEvents {
    public static final Component LOCKED_MESSAGE = Component.m_237115_((String)"locks.status.locked");

    private LocksForgeEvents() {
    }

    @SubscribeEvent
    public static void attachCapabilitiesToWorld(AttachCapabilitiesEvent<Level> e) {
        LocksCapabilities.attachToWorld(e);
    }

    @SubscribeEvent
    public static void attachCapabilitiesToChunk(AttachCapabilitiesEvent<LevelChunk> e) {
        LocksCapabilities.attachToChunk(e);
    }

    @SubscribeEvent
    public static void attachCapabilitiesToEntity(AttachCapabilitiesEvent<Entity> e) {
        LocksCapabilities.attachToEntity(e);
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent e) {
        ResourceLocation name = e.getName();
        if (!name.m_135827_().equals("minecraft") || !name.m_135815_().startsWith("chests")) {
            return;
        }
        ResourceLocation injectLoc = new ResourceLocation("locks", "loot_tables/inject/" + name.m_135815_() + ".json");
        if (LocksUtil.resourceManager.m_213713_(injectLoc).isEmpty()) {
            return;
        }
    }

    @SubscribeEvent
    public static void addVillagerTrades(VillagerTradesEvent e) {
        if (e.getType() != VillagerProfession.f_35598_) {
            return;
        }
        Int2ObjectMap levels = e.getTrades();
        List trades = (List)levels.get(1);
        trades.add(new VillagerTrades.ItemsForEmeralds(new ItemStack((ItemLike)LocksItems.WOOD_LOCK_PICK.get()), 1, 2, 16, 2, 0.05f));
        trades.add(new VillagerTrades.ItemsForEmeralds(new ItemStack((ItemLike)LocksItems.WOOD_LOCK_MECHANISM.get()), 2, 1, 12, 1, 0.2f));
        trades = (List)levels.get(2);
        trades.add(new VillagerTrades.ItemsForEmeralds(new ItemStack((ItemLike)LocksItems.IRON_LOCK_PICK.get()), 2, 2, 16, 5, 0.05f));
        trades = (List)levels.get(3);
        trades.add(new VillagerTrades.ItemsForEmeralds(new ItemStack((ItemLike)LocksItems.GOLD_LOCK_PICK.get()), 6, 2, 12, 20, 0.05f));
        trades.add(new VillagerTrades.ItemsForEmeralds(new ItemStack((ItemLike)LocksItems.IRON_LOCK_MECHANISM.get()), 5, 1, 8, 10, 0.2f));
        trades = (List)levels.get(4);
        trades.add(new VillagerTrades.ItemsForEmeralds(new ItemStack((ItemLike)LocksItems.STEEL_LOCK_PICK.get()), 4, 2, 16, 20, 0.05f));
        trades = (List)levels.get(5);
        trades.add(new VillagerTrades.ItemsForEmeralds(new ItemStack((ItemLike)LocksItems.DIAMOND_LOCK_PICK.get()), 8, 2, 12, 30, 0.05f));
        trades.add(new VillagerTrades.ItemsForEmeralds(new ItemStack((ItemLike)LocksItems.STEEL_LOCK_MECHANISM.get()), 8, 1, 8, 30, 0.2f));
    }

    @SubscribeEvent
    public static void addWandererTrades(WandererTradesEvent e) {
        List trades = e.getGenericTrades();
        trades.add(new VillagerTrades.ItemsForEmeralds((Item)LocksItems.GOLD_LOCK_PICK.get(), 5, 2, 6, 1));
        trades.add(new VillagerTrades.ItemsForEmeralds((Item)LocksItems.STEEL_LOCK_PICK.get(), 3, 2, 8, 1));
        trades.add(new VillagerTrades.EnchantedItemForEmeralds((Item)LocksItems.STEEL_LOCK.get(), 16, 4, 1));
        trades = e.getRareTrades();
        trades.add(new VillagerTrades.ItemsForEmeralds((Item)LocksItems.STEEL_LOCK_MECHANISM.get(), 6, 1, 4, 1));
        trades.add(new VillagerTrades.EnchantedItemForEmeralds((Item)LocksItems.DIAMOND_LOCK.get(), 28, 4, 1));
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload e) {
        LevelChunk ch = (LevelChunk)e.getChunk();
        ILockableHandler handler = (ILockableHandler)ch.m_62953_().getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null);
        ((ILockableStorage)ch.getCapability(LocksCapabilities.LOCKABLE_STORAGE).orElse(null)).get().values().forEach(lkb -> {
            handler.getLoaded().remove(lkb.id);
            lkb.deleteObserver(handler);
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRightClick(PlayerInteractEvent.RightClickBlock e) {
        BlockPos pos = e.getPos();
        Level world = e.getLevel();
        Player player = e.getEntity();
        ILockableHandler handler = (ILockableHandler)world.getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null);
        Lockable[] intersect = (Lockable[])handler.getInChunk(pos).values().stream().filter(lkb -> lkb.bb.intersects(pos)).toArray(Lockable[]::new);
        if (intersect.length == 0) {
            return;
        }
        if (e.getHand() != InteractionHand.MAIN_HAND) {
            e.setUseBlock(Event.Result.DENY);
            return;
        }
        ItemStack stack = e.getItemStack();
        Optional<Lockable> locked = Arrays.stream(intersect).filter(LocksPredicates.LOCKED).findFirst();
        if (locked.isPresent()) {
            Lockable lkb2 = locked.get();
            e.setUseBlock(Event.Result.DENY);
            Item item = stack.m_41720_();
            if (!(stack.m_204117_(LocksItemTags.LOCK_PICKS) || item == LocksItems.MASTER_KEY.get() || stack.m_204117_(LocksItemTags.KEYS) && LockingItem.getOrSetId(stack) == lkb2.lock.id || item == LocksItems.KEY_RING.get() && KeyRingItem.containsId(stack, lkb2.lock.id))) {
                lkb2.swing(20);
                world.m_5594_(player, pos, (SoundEvent)LocksSoundEvents.LOCK_RATTLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            player.m_6674_(InteractionHand.MAIN_HAND);
            if (world.f_46443_ && ((Boolean)LocksClientConfig.DEAF_MODE.get()).booleanValue()) {
                player.m_5661_(LOCKED_MESSAGE, true);
            }
            return;
        }
        if (((Boolean)LocksServerConfig.ALLOW_REMOVING_LOCKS.get()).booleanValue() && player.m_6144_() && stack.m_41619_()) {
            Lockable[] match = (Lockable[])Arrays.stream(intersect).filter(LocksPredicates.NOT_LOCKED).toArray(Lockable[]::new);
            if (match.length == 0) {
                return;
            }
            e.setUseBlock(Event.Result.DENY);
            world.m_5594_(player, pos, SoundEvents.f_12056_, SoundSource.BLOCKS, 0.8f, 0.8f + world.f_46441_.m_188501_() * 0.4f);
            player.m_6674_(InteractionHand.MAIN_HAND);
            if (!world.f_46443_) {
                for (Lockable lkb3 : match) {
                    world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, lkb3.stack));
                    handler.remove(lkb3.id);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase != TickEvent.Phase.START) {
            return;
        }
        ISelection select = (ISelection)e.player.getCapability(LocksCapabilities.SELECTION).orElse(null);
        if (select == null || select.get() == null) {
            return;
        }
        for (ItemStack stack : e.player.m_6167_()) {
            if (!stack.m_204117_(LocksItemTags.LOCKS)) continue;
            return;
        }
        select.set(null);
    }

    public static boolean canBreakLockable(Player player, BlockPos pos) {
        return (Boolean)LocksServerConfig.PROTECT_LOCKABLES.get() != false && !player.m_7500_() && LocksUtil.lockedAndRelated(player.m_9236_(), pos);
    }

    @SubscribeEvent
    public static void onBlockBreaking(PlayerEvent.BreakSpeed e) {
        e.setCanceled(LocksForgeEvents.canBreakLockable(e.getEntity(), (BlockPos)e.getPosition().get()));
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent e) {
        e.setCanceled(LocksForgeEvents.canBreakLockable(e.getPlayer(), e.getPos()));
    }
}

