/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.container;

import java.util.function.Consumer;
import melonslise.locks.client.gui.LockPickingScreen;
import melonslise.locks.common.capability.ILockableHandler;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.init.LocksContainerTypes;
import melonslise.locks.common.init.LocksDamageSources;
import melonslise.locks.common.init.LocksEnchantments;
import melonslise.locks.common.init.LocksItemTags;
import melonslise.locks.common.init.LocksNetwork;
import melonslise.locks.common.init.LocksSoundEvents;
import melonslise.locks.common.item.LockPickItem;
import melonslise.locks.common.network.toclient.TryPinResultPacket;
import melonslise.locks.common.util.Lockable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.network.PacketDistributor;

public class LockPickingContainer
extends AbstractContainerMenu {
    public static final Component TITLE = Component.m_237115_((String)"locks.gui.lockpicking.title");
    public final Player player;
    public final InteractionHand hand;
    public final Lockable lockable;
    public final Vec3 pos;
    public final int shocking;
    public final int sturdy;
    public final int complexity;
    protected int currIndex = 0;
    public static final IContainerFactory<LockPickingContainer> FACTORY = (id, inv, buf) -> new LockPickingContainer(id, inv.f_35978_, (InteractionHand)buf.m_130066_(InteractionHand.class), (Lockable)((ILockableHandler)inv.f_35978_.m_9236_().getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null)).getLoaded().get(buf.readInt()));

    public LockPickingContainer(int id, Player player, InteractionHand hand, Lockable lkb) {
        super((MenuType)LocksContainerTypes.LOCK_PICKING.get(), id);
        this.player = player;
        this.hand = hand;
        this.lockable = lkb;
        Lockable.State state = lkb.getLockState(player.m_9236_());
        this.pos = state == null ? lkb.bb.center() : state.pos;
        this.shocking = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)LocksEnchantments.SHOCKING.get()), (ItemStack)this.lockable.stack);
        this.sturdy = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)LocksEnchantments.STURDY.get()), (ItemStack)this.lockable.stack);
        this.complexity = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)LocksEnchantments.COMPLEXITY.get()), (ItemStack)this.lockable.stack);
        for (int rows = 0; rows < 3; ++rows) {
            for (int cols = 0; cols < 9; ++cols) {
                this.m_38897_(new HiddenSlot(player.m_150109_(), cols + rows * 9 + 9, 0, 0));
            }
        }
        for (int slots = 0; slots < 9; ++slots) {
            this.m_38897_(new HiddenSlot(player.m_150109_(), slots, 0, 0));
        }
    }

    public boolean isValidPick(ItemStack stack) {
        return stack.m_204117_(LocksItemTags.LOCK_PICKS) && LockPickItem.canPick(stack, this.complexity);
    }

    public boolean m_6875_(Player player) {
        return this.lockable.lock.isLocked() && this.isValidPick(player.m_21120_(this.hand));
    }

    public boolean isOpen() {
        return this.currIndex == this.lockable.lock.getLength();
    }

    protected void reset() {
        this.currIndex = 0;
    }

    public void tryPin(int currPin) {
        if (this.isOpen()) {
            return;
        }
        boolean correct = false;
        boolean reset = false;
        if (this.lockable.lock.checkPin(this.currIndex, currPin)) {
            ++this.currIndex;
            correct = true;
            this.player.m_9236_().m_6263_(null, this.pos.f_82479_, this.pos.f_82480_, this.pos.f_82481_, (SoundEvent)LocksSoundEvents.PIN_MATCH.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (this.tryBreakPick(this.player, currPin)) {
            reset = true;
            this.reset();
            if (this.shocking > 0) {
                this.player.m_6469_(LocksDamageSources.getDamageSource(this.player.m_9236_(), LocksDamageSources.SHOCK), (float)this.shocking * 1.5f);
                this.player.m_9236_().m_6263_(null, this.player.m_20182_().f_82479_, this.player.m_20182_().f_82480_, this.player.m_20182_().f_82481_, (SoundEvent)LocksSoundEvents.SHOCK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        } else {
            this.player.m_9236_().m_6263_(null, this.pos.f_82479_, this.pos.f_82480_, this.pos.f_82481_, (SoundEvent)LocksSoundEvents.PIN_FAIL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        LocksNetwork.MAIN.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.player), (Object)new TryPinResultPacket(correct, reset));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handlePin(boolean correct, boolean reset) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof LockPickingScreen) {
            LockPickingScreen lockPickingScreen = (LockPickingScreen)screen;
            lockPickingScreen.handlePin(correct, reset);
            if (correct) {
                ++this.currIndex;
            }
            if (reset) {
                this.reset();
            }
        }
    }

    protected boolean tryBreakPick(Player player, int pin) {
        ItemStack pickStack = player.m_21120_(this.hand);
        float sturdyModifier = this.sturdy == 0 ? 1.0f : 0.75f + (float)this.sturdy * 0.5f;
        float ch = LockPickItem.getOrSetStrength(pickStack) / sturdyModifier;
        float ex = (1.0f - ch) * (1.0f - this.getBreakChanceMultiplier(pin));
        if (!pickStack.m_204117_(LocksItemTags.LOCK_PICKS) || player.m_9236_().f_46441_.m_188501_() < ex + ch) {
            return false;
        }
        this.player.m_21190_(this.hand);
        pickStack.m_41774_(1);
        if (pickStack.m_41619_()) {
            for (int a = 0; a < player.m_150109_().m_6643_(); ++a) {
                ItemStack stack = player.m_150109_().m_8020_(a);
                if (!this.isValidPick(stack)) continue;
                player.m_21008_(this.hand, stack);
                player.m_150109_().m_8016_(a);
                break;
            }
        }
        return true;
    }

    protected float getBreakChanceMultiplier(int pin) {
        return Math.abs(this.lockable.lock.getPin(this.currIndex) - pin) == 1 ? 0.33f : 1.0f;
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (!this.isOpen() || !this.lockable.lock.isLocked()) {
            return;
        }
        this.lockable.lock.setLocked(!this.lockable.lock.isLocked());
        this.player.m_9236_().m_6263_(player, this.pos.f_82479_, this.pos.f_82480_, this.pos.f_82481_, (SoundEvent)LocksSoundEvents.LOCK_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static class HiddenSlot
    extends Slot {
        public HiddenSlot(Inventory inventoryIn, int index, int xPosition, int yPosition) {
            super((Container)inventoryIn, index, xPosition, yPosition);
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean m_6659_() {
            return false;
        }
    }

    public static class Provider
    implements MenuProvider {
        public final InteractionHand hand;
        public final Lockable lockable;

        public Provider(InteractionHand hand, Lockable lkb) {
            this.hand = hand;
            this.lockable = lkb;
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
            return new LockPickingContainer(id, player, this.hand, this.lockable);
        }

        public Component m_5446_() {
            return TITLE;
        }
    }

    public static class Writer
    implements Consumer<FriendlyByteBuf> {
        public final InteractionHand hand;
        public final Lockable lockable;

        public Writer(InteractionHand hand, Lockable lkb) {
            this.hand = hand;
            this.lockable = lkb;
        }

        @Override
        public void accept(FriendlyByteBuf buf) {
            buf.m_130068_((Enum)this.hand);
            buf.writeInt(this.lockable.id);
        }
    }
}

