/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.container;

import java.util.function.Consumer;
import melonslise.locks.common.init.LocksContainerTypes;
import melonslise.locks.common.init.LocksSoundEvents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.network.IContainerFactory;

public class KeyRingContainer
extends AbstractContainerMenu {
    public final ItemStack stack;
    public final IItemHandler inv;
    public final int rows;
    public static final IContainerFactory<KeyRingContainer> FACTORY = (id, inv, buffer) -> new KeyRingContainer(id, inv.f_35978_, inv.f_35978_.m_21120_((InteractionHand)buffer.m_130066_(InteractionHand.class)));

    public KeyRingContainer(int id, Player player, ItemStack stack) {
        super((MenuType)LocksContainerTypes.KEY_RING.get(), id);
        this.stack = stack;
        this.inv = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        this.rows = this.inv.getSlots() / 9;
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_((Slot)new KeyRingSlot(player, this.inv, col + row * 9, 8 + col * 18, 18 + row * 18));
            }
        }
        int offset = (this.rows - 4) * 18;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)player.m_150109_(), col + row * 9 + 9, 8 + col * 18, 103 + row * 18 + offset));
            }
        }
        for (int coll = 0; coll < 9; ++coll) {
            this.m_38897_(new Slot((Container)player.m_150109_(), coll, 8 + coll * 18, 161 + offset));
        }
    }

    public boolean m_6875_(Player player) {
        return !this.stack.m_41619_();
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot == null || !slot.m_6657_()) {
            return stack;
        }
        ItemStack stack1 = slot.m_7993_();
        stack = stack1.m_41777_();
        if (index < this.inv.getSlots() ? !this.m_38903_(stack1, this.inv.getSlots(), this.f_38839_.size(), true) : !this.m_38903_(stack1, 0, this.inv.getSlots(), false)) {
            return ItemStack.f_41583_;
        }
        if (stack1.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        return stack;
    }

    public static class KeyRingSlot
    extends SlotItemHandler {
        public final Player player;

        public KeyRingSlot(Player player, IItemHandler inv, int index, int x, int y) {
            super(inv, index, x, y);
            this.player = player;
        }

        public void m_5852_(ItemStack stack) {
            super.m_5852_(stack);
            if (!this.player.m_9236_().f_46443_) {
                this.player.m_9236_().m_6263_(null, this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_(), (SoundEvent)LocksSoundEvents.KEY_RING.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }

        public void m_142406_(Player player, ItemStack stack) {
            if (!this.player.m_9236_().f_46443_) {
                this.player.m_9236_().m_6263_(null, this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_(), (SoundEvent)LocksSoundEvents.KEY_RING.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            super.m_142406_(player, stack);
        }
    }

    public static class Writer
    implements Consumer<FriendlyByteBuf> {
        public final InteractionHand hand;

        public Writer(InteractionHand hand) {
            this.hand = hand;
        }

        @Override
        public void accept(FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)this.hand);
        }
    }

    public static class Provider
    implements MenuProvider {
        public final ItemStack stack;

        public Provider(ItemStack stack) {
            this.stack = stack;
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
            return new KeyRingContainer(id, player, this.stack);
        }

        public Component m_5446_() {
            return this.stack.m_41786_();
        }
    }
}

