/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.capability;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import melonslise.locks.common.capability.ILockableHandler;
import melonslise.locks.common.capability.ILockableStorage;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.util.Lockable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;

@AutoRegisterCapability
public class LockableStorage
implements ILockableStorage {
    public static final ResourceLocation ID = new ResourceLocation("locks", "lockable_storage");
    public final LevelChunk chunk;
    public Int2ObjectMap<Lockable> lockables = new Int2ObjectLinkedOpenHashMap();

    public LockableStorage(LevelChunk chunk) {
        this.chunk = chunk;
    }

    @Override
    public Int2ObjectMap<Lockable> get() {
        return this.lockables;
    }

    @Override
    public void add(Lockable lkb) {
        this.lockables.put(lkb.id, (Object)lkb);
        this.chunk.m_8092_(true);
    }

    @Override
    public void remove(int id) {
        this.lockables.remove(id);
        this.chunk.m_8092_(true);
    }

    public ListTag serializeNBT() {
        ListTag list = new ListTag();
        for (Lockable lkb : this.lockables.values()) {
            list.add((Object)Lockable.toNbt(lkb));
        }
        return list;
    }

    public void deserializeNBT(ListTag nbt) {
        ILockableHandler handler = (ILockableHandler)this.chunk.m_62953_().getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null);
        Int2ObjectMap<Lockable> lkbs = handler.getLoaded();
        for (int a = 0; a < nbt.size(); ++a) {
            CompoundTag nbt1 = nbt.m_128728_(a);
            Lockable lkb = (Lockable)lkbs.get(Lockable.idFromNbt(nbt1));
            if (lkb == lkbs.defaultReturnValue()) {
                lkb = Lockable.fromNbt(nbt1);
                lkb.addObserver(handler);
                lkbs.put(lkb.id, (Object)lkb);
            }
            this.lockables.put(lkb.id, (Object)lkb);
        }
    }
}

