/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.capability;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.concurrent.atomic.AtomicInteger;
import melonslise.locks.Locks;
import melonslise.locks.common.capability.ILockableHandler;
import melonslise.locks.common.capability.ILockableStorage;
import melonslise.locks.common.capability.LockableStorage;
import melonslise.locks.common.config.LocksServerConfig;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.init.LocksNetwork;
import melonslise.locks.common.init.LocksPacketDistributors;
import melonslise.locks.common.network.toclient.AddLockablePacket;
import melonslise.locks.common.network.toclient.RemoveLockablePacket;
import melonslise.locks.common.network.toclient.UpdateLockablePacket;
import melonslise.locks.common.util.Lockable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.IntTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;

@AutoRegisterCapability
public class LockableHandler
implements ILockableHandler {
    public static final ResourceLocation ID = new ResourceLocation("locks", "lockable_handler");
    public final Level world;
    public AtomicInteger lastId = new AtomicInteger();
    public Int2ObjectMap<Lockable> lockables = new Int2ObjectLinkedOpenHashMap();

    public LockableHandler(Level world) {
        this.world = world;
    }

    @Override
    public int nextId() {
        return this.lastId.incrementAndGet();
    }

    @Override
    public Int2ObjectMap<Lockable> getLoaded() {
        return this.lockables;
    }

    @Override
    public Int2ObjectMap<Lockable> getInChunk(BlockPos pos) {
        return this.world.m_46805_(pos) ? ((ILockableStorage)this.world.m_46745_(pos).getCapability(LocksCapabilities.LOCKABLE_STORAGE).orElse(null)).get() : Int2ObjectMaps.emptyMap();
    }

    @Override
    public boolean add(Lockable lkb) {
        if (lkb.bb.volume() > (Integer)LocksServerConfig.MAX_LOCKABLE_VOLUME.get()) {
            return false;
        }
        List<ILockableStorage> sts = lkb.bb.containedChunksTo((x, z) -> {
            try {
                LevelChunk levelChunk = this.world.m_6325_(x, z);
                ILockableStorage st = (ILockableStorage)levelChunk.getCapability(LocksCapabilities.LOCKABLE_STORAGE).orElseThrow(NullPointerException::new);
                return st.get().values().stream().anyMatch(lkb1 -> lkb1.bb.intersects(lkb.bb)) ? null : st;
            }
            catch (Exception e) {
                Locks.LOGGER.warn("Chunk not gen");
                return null;
            }
        }, true);
        if (sts == null) {
            return false;
        }
        for (int a = 0; a < sts.size(); ++a) {
            sts.get(a).add(lkb);
        }
        this.lockables.put(lkb.id, (Object)lkb);
        lkb.addObserver(this);
        if (this.world.f_46443_) {
            lkb.swing(10);
        } else {
            LocksNetwork.MAIN.send(LocksPacketDistributors.TRACKING_AREA.with(() -> sts.stream().map(st -> ((LockableStorage)st).chunk)), (Object)new AddLockablePacket(lkb));
        }
        return true;
    }

    @Override
    public boolean remove(int id) {
        Lockable lkb = (Lockable)this.lockables.get(id);
        if (lkb == this.lockables.defaultReturnValue()) {
            return false;
        }
        List<LevelChunk> chs = lkb.bb.containedChunksTo((x, z) -> this.world.m_7232_(x, z) ? this.world.m_6325_(x, z) : null, true);
        for (int a = 0; a < chs.size(); ++a) {
            ((ILockableStorage)chs.get(a).getCapability(LocksCapabilities.LOCKABLE_STORAGE).orElse(null)).remove(id);
        }
        this.lockables.remove(id);
        lkb.deleteObserver(this);
        if (this.world.f_46443_) {
            return true;
        }
        LocksNetwork.MAIN.send(LocksPacketDistributors.TRACKING_AREA.with(() -> chs.stream()), (Object)new RemoveLockablePacket(id));
        return true;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.world.f_46443_ || !(o instanceof Lockable)) {
            return;
        }
        Lockable lockable = (Lockable)o;
        LocksNetwork.MAIN.send(LocksPacketDistributors.TRACKING_AREA.with(() -> lockable.bb.containedChunksTo((x, z) -> this.world.m_7232_(x, z) ? this.world.m_6325_(x, z) : null, false).stream().filter(Objects::nonNull)), (Object)new UpdateLockablePacket(lockable));
    }

    public IntTag serializeNBT() {
        return IntTag.m_128679_((int)this.lastId.get());
    }

    public void deserializeNBT(IntTag nbt) {
        this.lastId.set(nbt.m_7047_());
    }
}

