/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.capability;

import javax.annotation.Nonnull;
import melonslise.locks.common.init.LocksItemTags;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class KeyRingInventory
implements IItemHandlerModifiable {
    public final int size;
    public final ItemStack stack;

    public KeyRingInventory(ItemStack stack, int rows, int col) {
        this.size = rows * col;
        this.stack = stack;
    }

    public int getSlots() {
        return this.size;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        ListTag list = this.stack.m_41784_().m_128437_("Items", 10);
        for (int a = 0; a < list.size(); ++a) {
            CompoundTag nbt = list.m_128728_(a);
            if (nbt.m_128451_("Slot") != slot) continue;
            return ItemStack.m_41712_((CompoundTag)nbt);
        }
        return ItemStack.f_41583_;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        CompoundTag nbt = null;
        if (!stack.m_41619_()) {
            nbt = new CompoundTag();
            nbt.m_128405_("Slot", slot);
            stack.m_41739_(nbt);
        }
        ListTag list = this.stack.m_41784_().m_128437_("Items", 10);
        for (int a = 0; a < list.size(); ++a) {
            CompoundTag existing = list.m_128728_(a);
            if (existing.m_128451_("Slot") != slot) continue;
            if (!stack.m_41619_()) {
                list.set(a, (Tag)nbt);
            } else {
                list.remove(a);
            }
            return;
        }
        if (!stack.m_41619_()) {
            list.add((Object)nbt);
        }
        this.stack.m_41784_().m_128365_("Items", (Tag)list);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        int limit = stack.m_41741_();
        if (!existing.m_41619_()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.m_41613_();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.m_41613_() > limit;
        if (!simulate) {
            if (existing.m_41613_() <= 0) {
                existing = reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack;
            } else {
                existing.m_41769_(reachedLimit ? limit : stack.m_41613_());
            }
            this.setStackInSlot(slot, existing);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - limit)) : ItemStack.f_41583_;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        if (existing.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int toExtract = Math.min(amount, existing.m_41741_());
        if (existing.m_41613_() <= toExtract) {
            if (!simulate) {
                this.setStackInSlot(slot, ItemStack.f_41583_);
            }
            return existing;
        }
        if (!simulate) {
            this.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract)));
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    private void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return stack.m_204117_(LocksItemTags.KEYS);
    }
}

