/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.client.util;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public final class LocksClientUtil {
    private LocksClientUtil() {
    }

    public static Camera getCamera() {
        return Minecraft.m_91087_().f_91063_.m_109153_();
    }

    public static Frustum getFrustum(PoseStack mtx, Matrix4f proj) {
        Frustum ch = Minecraft.m_91087_().f_91060_.getFrustum();
        if (ch != null) {
            return ch;
        }
        ch = new Frustum(mtx.m_85850_().m_252922_(), proj);
        Vec3 pos = LocksClientUtil.getCamera().m_90583_();
        ch.m_113002_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        return ch;
    }

    public static double distanceToLineSq(Vec3 p, Vec3 l1, Vec3 l2) {
        Vec3 l = l2.m_82546_(l1);
        return l.m_82537_(p.m_82546_(l1)).m_82556_() / l.m_82556_();
    }

    public static Vector3f worldToScreen(Vec3 pos, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        Camera cam = LocksClientUtil.getCamera();
        Vec3 o = cam.m_90583_();
        Vector3f pos1 = new Vector3f((float)(o.f_82479_ - pos.f_82479_), (float)(o.f_82480_ - pos.f_82480_), (float)(o.f_82481_ - pos.f_82481_));
        Quaternionf rot = new Quaternionf((Quaternionfc)cam.m_253121_());
        rot.conjugate();
        pos1.rotate((Quaternionfc)rot);
        if (((Boolean)mc.f_91066_.m_231830_().m_231551_()).booleanValue() && mc.m_91288_() instanceof Player) {
            Player player = (Player)mc.m_91288_();
            float f = player.f_19787_ - player.f_19867_;
            float f1 = -(player.f_19787_ + f * partialTicks);
            float f2 = Mth.m_14179_((float)partialTicks, (float)player.f_36099_, (float)player.f_36100_);
            float angle1 = Math.abs(Mth.m_14089_((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 5.0f;
            Quaternionf rot1 = new Quaternionf().rotateX(angle1);
            float angle2 = Mth.m_14031_((float)(f1 * (float)Math.PI)) * f2 * 3.0f;
            Quaternionf rot2 = new Quaternionf().rotateZ(angle2);
            rot1.conjugate();
            rot2.conjugate();
            pos1.rotate((Quaternionfc)rot1);
            pos1.rotate((Quaternionfc)rot2);
            pos1.add(Mth.m_14031_((float)(f1 * (float)Math.PI)) * f2 * 0.5f, Math.abs(Mth.m_14089_((float)(f1 * (float)Math.PI)) * f2), 0.0f);
        }
        Window w = mc.m_91268_();
        float sc = (float)w.m_85446_() / 2.0f / pos1.z() / (float)Math.tan(Math.toRadians(mc.f_91063_.m_109141_(cam, partialTicks, true) / 2.0));
        pos1.mul(-sc, -sc, 1.0f);
        pos1.add((float)w.m_85445_() / 2.0f, (float)w.m_85446_() / 2.0f, 0.0f);
        return pos1;
    }

    public static void texture(PoseStack mtx, float x, float y, int u, int v, int width, int height, int texWidth, int texHeight, float alpha) {
        Matrix4f last = mtx.m_85850_().m_252922_();
        float f = 1.0f / (float)texWidth;
        float f1 = 1.0f / (float)texHeight;
        BufferBuilder buf = Tesselator.m_85913_().m_85915_();
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        buf.m_252986_(last, x, y + (float)height, 0.0f).m_7421_((float)u * f, (float)(v + height) * f1).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        buf.m_252986_(last, x + (float)width, y + (float)height, 0.0f).m_7421_((float)(u + width) * f, (float)(v + height) * f1).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        buf.m_252986_(last, x + (float)width, y, 0.0f).m_7421_((float)(u + width) * f, (float)v * f1).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        buf.m_252986_(last, x, y, 0.0f).m_7421_((float)u * f, (float)v * f1).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        buf.m_231175_();
    }

    public static void line(BufferBuilder buf, PoseStack mtx, float x1, float y1, float x2, float y2, float width, float r, float g, float b, float a) {
        Matrix4f last = mtx.m_85850_().m_252922_();
        float pX = y2 - y1;
        float pY = x1 - x2;
        float pL = Mth.m_14116_((float)(pX * pX + pY * pY));
        buf.m_252986_(last, x1 + (pX *= width / 2.0f / pL), y1 + (pY *= width / 2.0f / pL), 0.0f).m_85950_(r, g, b, a).m_5752_();
        buf.m_252986_(last, x1 - pX, y1 - pY, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buf.m_252986_(last, x2 - pX, y2 - pY, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buf.m_252986_(last, x2 + pX, y2 + pY, 0.0f).m_85950_(r, g, b, a).m_5752_();
    }

    public static void square(BufferBuilder buf, PoseStack mtx, float x, float y, float length, float r, float g, float b, float a) {
        Matrix4f last = mtx.m_85850_().m_252922_();
        buf.m_252986_(last, x - (length /= 2.0f), y - length, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buf.m_252986_(last, x - length, y + length, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buf.m_252986_(last, x + length, y + length, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buf.m_252986_(last, x + length, y - length, 0.0f).m_85950_(r, g, b, a).m_5752_();
    }

    public static void vGradient(BufferBuilder bld, PoseStack mtx, int x1, int y1, int x2, int y2, float r1, float g1, float b1, float a1, float r2, float g2, float b2, float a2) {
        Matrix4f last = mtx.m_85850_().m_252922_();
        bld.m_252986_(last, (float)x2, (float)y1, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
        bld.m_252986_(last, (float)x1, (float)y1, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
        bld.m_252986_(last, (float)x1, (float)y2, 0.0f).m_85950_(r2, g2, b2, a2).m_5752_();
        bld.m_252986_(last, (float)x2, (float)y2, 0.0f).m_85950_(r2, g2, b2, a2).m_5752_();
    }

    public static float lerp(float start, float end, float progress) {
        return start + (end - start) * progress;
    }

    public static double lerp(double start, double end, double progress) {
        return start + (end - start) * progress;
    }

    public static float cubicBezier1d(float anchor1, float anchor2, float progress) {
        float omp = 1.0f - progress;
        return 3.0f * omp * omp * progress * anchor1 + 3.0f * omp * progress * progress * anchor2 + progress * progress * progress;
    }
}

