/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.client.gui.sprite;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayDeque;
import java.util.Queue;
import melonslise.locks.client.gui.sprite.TextureInfo;
import melonslise.locks.client.gui.sprite.action.IAction;
import melonslise.locks.client.util.LocksClientUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class Sprite {
    private Queue<IAction> actions = new ArrayDeque<IAction>(4);
    public TextureInfo tex;
    public float posX;
    public float posY;
    public float oldPosX;
    public float oldPosY;
    public float speedX;
    public float speedY;
    public float rot;
    public float oldRot;
    public float rotSpeed;
    public float originX;
    public float originY;
    public float alpha = 1.0f;
    public float oldAlpha = 1.0f;

    public Sprite(TextureInfo tex) {
        this.tex = tex;
    }

    public Sprite position(float posX, float posY) {
        this.posX = this.oldPosX = posX;
        this.posY = this.oldPosY = posY;
        return this;
    }

    public Sprite rotation(float rot, float originX, float originY) {
        this.rot = this.oldRot = rot;
        this.originX = originX;
        this.originY = originY;
        return this;
    }

    public Sprite alpha(float alpha) {
        this.alpha = this.oldAlpha = alpha;
        return this;
    }

    public void execute(IAction ... actions) {
        for (IAction action : actions) {
            this.actions.offer(action);
        }
    }

    public boolean isExecuting() {
        return !this.actions.isEmpty();
    }

    public void draw(GuiGraphics guiGraphics, float partialTick, ResourceLocation location) {
        if (this.alpha <= 0.0f) {
            return;
        }
        PoseStack mtx = guiGraphics.m_280168_();
        mtx.m_85836_();
        mtx.m_252880_(this.originX, this.originY, 0.0f);
        mtx.m_252781_(new Quaternionf().rotateZ(-LocksClientUtil.lerp(this.oldRot, this.rot, partialTick)));
        mtx.m_252880_(-this.originX, -this.originY, 0.0f);
        this.tex.draw(guiGraphics, LocksClientUtil.lerp(this.oldPosX, this.posX, partialTick), LocksClientUtil.lerp(this.oldPosY, this.posY, partialTick), LocksClientUtil.lerp(this.oldAlpha, this.alpha, partialTick), location);
        mtx.m_85849_();
    }

    public void update() {
        this.oldPosX = this.posX;
        this.oldPosY = this.posY;
        this.oldRot = this.rot;
        this.oldAlpha = this.alpha;
        this.posX += this.speedX;
        this.posY += this.speedY;
        this.rot += this.rotSpeed;
        IAction action = this.actions.peek();
        if (action == null) {
            return;
        }
        if (action.isFinished(this)) {
            this.actions.poll().finish(this);
        } else {
            action.update(this);
        }
    }
}

