/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import melonslise.locks.client.gui.sprite.SpringSprite;
import melonslise.locks.client.gui.sprite.Sprite;
import melonslise.locks.client.gui.sprite.TextureInfo;
import melonslise.locks.client.gui.sprite.action.AccelerateAction;
import melonslise.locks.client.gui.sprite.action.FadeAction;
import melonslise.locks.client.gui.sprite.action.IAction;
import melonslise.locks.client.gui.sprite.action.MoveAction;
import melonslise.locks.client.gui.sprite.action.WaitAction;
import melonslise.locks.common.container.LockPickingContainer;
import melonslise.locks.common.init.LocksNetwork;
import melonslise.locks.common.network.toserver.TryPinPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class LockPickingScreen
extends AbstractContainerScreen<LockPickingContainer> {
    public static final Component HINT = Component.m_237115_((String)"locks.gui.lockpicking.open");
    public final TextureInfo FRONT_WALL_TEX;
    public final TextureInfo COLUMN_TEX;
    public final TextureInfo INNER_WALL_TEX;
    public final TextureInfo BACK_WALL_TEX;
    public final TextureInfo HANDLE_TEX;
    public final TextureInfo UPPER_PIN_TEX;
    public final TextureInfo LOCK_PICK_TEX;
    public final TextureInfo[] PIN_TUMBLER_TEX;
    public final TextureInfo[] SPRING_TEX;
    protected ResourceLocation lockTex;
    protected ResourceLocation pickTex;
    protected Collection<Sprite> sprites;
    protected Sprite lockPick;
    protected Sprite leftPickPart;
    protected Sprite rightPickPart;
    protected Sprite[] pinTumblers;
    protected Sprite[] upperPins;
    protected Sprite[] springs;
    public final BiConsumer<IAction<Sprite>, Sprite> unfreezeCb;
    public final BiConsumer<IAction<Sprite>, Sprite> resetPickCb;
    public final int length;
    public final boolean[] pins;
    public final InteractionHand hand;
    protected int currPin;
    protected boolean frozen;

    public LockPickingScreen(LockPickingContainer cont, Inventory inv, Component title) {
        super((AbstractContainerMenu)cont, inv, title);
        this.FRONT_WALL_TEX = new TextureInfo(6, 0, 4, 60, 48, 80, this.lockTex);
        this.COLUMN_TEX = new TextureInfo(10, 0, 8, 60, 48, 80, this.lockTex);
        this.INNER_WALL_TEX = new TextureInfo(18, 0, 4, 60, 48, 80, this.lockTex);
        this.BACK_WALL_TEX = new TextureInfo(22, 0, 4, 60, 48, 80, this.lockTex);
        this.HANDLE_TEX = new TextureInfo(26, 0, 19, 73, 48, 80, this.lockTex);
        this.UPPER_PIN_TEX = new TextureInfo(0, 0, 6, 8, 48, 80, this.lockTex);
        this.LOCK_PICK_TEX = new TextureInfo(0, 0, 160, 12, 160, 16, this.pickTex);
        this.PIN_TUMBLER_TEX = new TextureInfo[]{new TextureInfo(0, 8, 6, 11, 48, 80, this.lockTex), new TextureInfo(0, 19, 6, 13, 48, 80, this.lockTex), new TextureInfo(0, 32, 6, 15, 48, 80, this.lockTex)};
        this.SPRING_TEX = new TextureInfo[]{new TextureInfo(0, 57, 6, 23, 48, 80, this.lockTex), new TextureInfo(6, 60, 6, 20, 48, 80, this.lockTex), new TextureInfo(12, 64, 6, 16, 48, 80, this.lockTex), new TextureInfo(18, 69, 6, 11, 48, 80, this.lockTex), new TextureInfo(24, 73, 6, 7, 48, 80, this.lockTex)};
        this.unfreezeCb = (action, sprite) -> {
            this.frozen = false;
        };
        this.resetPickCb = (action, sprite) -> this.resetPick();
        this.frozen = true;
        this.length = cont.lockable.lock.getLength();
        this.pins = new boolean[this.length];
        this.hand = cont.hand;
        this.lockTex = LockPickingScreen.getTextureFor(cont.lockable.stack);
        this.f_97726_ = (this.FRONT_WALL_TEX.width + this.length * (this.COLUMN_TEX.width + this.INNER_WALL_TEX.width)) * 2;
        this.f_97727_ = this.HANDLE_TEX.height * 2;
        this.sprites = new ArrayDeque<Sprite>(this.length * 3 + 4);
        this.pinTumblers = new Sprite[this.length];
        this.upperPins = new Sprite[this.length];
        this.springs = new Sprite[this.length];
        for (int a = 0; a < this.pinTumblers.length; ++a) {
            int r = ThreadLocalRandom.current().nextInt(3);
            this.pinTumblers[a] = this.addSprite(new Sprite(this.PIN_TUMBLER_TEX[r]).position(this.FRONT_WALL_TEX.width + 1 + a * (this.COLUMN_TEX.width + this.INNER_WALL_TEX.width), 43 - this.PIN_TUMBLER_TEX[r].height));
            this.upperPins[a] = new Sprite(this.UPPER_PIN_TEX).position(this.FRONT_WALL_TEX.width + 1 + a * (this.COLUMN_TEX.width + this.INNER_WALL_TEX.width), 43 - this.PIN_TUMBLER_TEX[r].height - this.UPPER_PIN_TEX.height);
            this.springs[a] = this.addSprite(new SpringSprite(this.SPRING_TEX, this.upperPins[a]).position(this.FRONT_WALL_TEX.width + 1 + a * (this.COLUMN_TEX.width + this.INNER_WALL_TEX.width), 3.0f));
            this.addSprite(this.upperPins[a]);
        }
        this.lockPick = this.addSprite(new Sprite(this.LOCK_PICK_TEX).position(0.0f, -4 + this.COLUMN_TEX.height - this.LOCK_PICK_TEX.height));
        this.resetPick();
        this.rightPickPart = this.addSprite(new Sprite(new TextureInfo(0, 0, 0, 12, 160, 16, this.pickTex)).position(-10.0f, this.lockPick.posY).alpha(0.0f));
        this.leftPickPart = this.addSprite(new Sprite(new TextureInfo(0, 0, 0, 12, 160, 16, this.pickTex)).position(0.0f, this.lockPick.posY).rotation(-24.5f, -10.0f, this.lockPick.posY + 13.0f).alpha(0.0f));
    }

    public static ResourceLocation getTextureFor(ItemStack stack) {
        return new ResourceLocation("locks", "textures/gui/" + ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_() + ".png");
    }

    public Sprite addSprite(Sprite sprite) {
        this.sprites.add(sprite);
        return sprite;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        float pt = this.f_96541_.m_91296_();
        int cornerX = (this.f_96543_ - this.f_97726_) / 2;
        int cornerY = (this.f_96544_ - this.f_97727_) / 2;
        PoseStack mtx = guiGraphics.m_280168_();
        mtx.m_85836_();
        mtx.m_252880_((float)cornerX, (float)cornerY, 0.0f);
        mtx.m_85841_(2.0f, 2.0f, 2.0f);
        this.FRONT_WALL_TEX.draw(guiGraphics, 0.0f, 0.0f, 1.0f, this.lockTex);
        for (int a = 0; a < this.length; ++a) {
            this.COLUMN_TEX.draw(guiGraphics, this.FRONT_WALL_TEX.width + a * (this.COLUMN_TEX.width + this.INNER_WALL_TEX.width), 0.0f, 1.0f, this.lockTex);
            if (a == this.length - 1) continue;
            this.INNER_WALL_TEX.draw(guiGraphics, this.FRONT_WALL_TEX.width + this.COLUMN_TEX.width + a * (this.COLUMN_TEX.width + this.INNER_WALL_TEX.width), 0.0f, 1.0f, this.lockTex);
        }
        this.BACK_WALL_TEX.draw(guiGraphics, this.length * (this.COLUMN_TEX.width + this.INNER_WALL_TEX.width), 0.0f, 1.0f, this.lockTex);
        this.HANDLE_TEX.draw(guiGraphics, this.BACK_WALL_TEX.width + this.length * (this.COLUMN_TEX.width + this.INNER_WALL_TEX.width), 2.0f, 1.0f, this.lockTex);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        for (Sprite sprite : this.sprites) {
            if (sprite == this.lockPick || sprite == this.rightPickPart || sprite == this.leftPickPart) {
                sprite.draw(guiGraphics, pt, this.pickTex);
                continue;
            }
            sprite.draw(guiGraphics, pt, this.lockTex);
        }
        mtx.m_85849_();
    }

    protected void m_280003_(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        Objects.requireNonNull(this.f_96547_);
        guiGraphics.m_280430_(this.f_96547_, this.f_96539_, 0, -9, 0xFFFFFF);
        if (((LockPickingContainer)this.m_6262_()).isOpen()) {
            guiGraphics.m_280430_(this.f_96547_, HINT, (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)HINT)) / 2, this.f_97727_ + 10, 0xFFFFFF);
        }
    }

    public void m_181908_() {
        super.m_181908_();
        for (Sprite sprite : this.sprites) {
            sprite.update();
        }
        if (!this.frozen) {
            this.boundLockPick();
        }
        this.updatePickParts();
    }

    protected void updatePickParts() {
        this.rightPickPart.posY = this.lockPick.posY;
        this.rightPickPart.tex.width = 10 + (int)this.lockPick.posX + this.lockPick.tex.width;
        this.rightPickPart.tex.startX = this.rightPickPart.tex.canvasWidth - this.rightPickPart.tex.width;
        this.leftPickPart.posY = this.lockPick.posY;
        this.leftPickPart.tex.width = this.rightPickPart.tex.startX;
        this.leftPickPart.posX = -10 - this.leftPickPart.tex.width;
    }

    protected void boundLockPick() {
        this.lockPick.posX = (float)(10 - this.LOCK_PICK_TEX.width) + Mth.m_14036_((float)(this.lockPick.posX - 10.0f + (float)this.LOCK_PICK_TEX.width), (float)0.0f, (float)((this.length - 1) * (this.COLUMN_TEX.width + this.INNER_WALL_TEX.width)));
    }

    public boolean m_7933_(int key, int scan, int modifier) {
        if (this.frozen) {
            return super.m_7933_(key, scan, modifier);
        }
        if (key == this.f_96541_.f_91066_.f_92086_.getKey().m_84873_()) {
            this.lockPick.speedX = -4.0f;
        } else if (key == this.f_96541_.f_91066_.f_92088_.getKey().m_84873_()) {
            this.lockPick.speedX = 4.0f;
        } else if (key == this.f_96541_.f_91066_.f_92085_.getKey().m_84873_() && !this.lockPick.isExecuting() && this.pullPin(this.getSelectedPin())) {
            this.lockPick.execute(MoveAction.at(0.0f, -2.5f).time(3), MoveAction.at(0.0f, 2.5f).time(3));
        }
        return super.m_7933_(key, scan, modifier);
    }

    public boolean m_7920_(int key, int scan, int modifier) {
        if (this.frozen) {
            return super.m_7920_(key, scan, modifier);
        }
        if (key == this.f_96541_.f_91066_.f_92086_.getKey().m_84873_() || key == this.f_96541_.f_91066_.f_92088_.getKey().m_84873_()) {
            this.lockPick.speedX = 0.0f;
        }
        return super.m_7920_(key, scan, modifier);
    }

    protected int getSelectedPin() {
        return (int)((this.lockPick.posX - 10.0f + (float)this.LOCK_PICK_TEX.width) / (float)(this.COLUMN_TEX.width + this.INNER_WALL_TEX.width) + 0.5f);
    }

    protected boolean pullPin(int pin) {
        if (this.pins[pin]) {
            return false;
        }
        this.currPin = pin;
        LocksNetwork.MAIN.sendToServer((Object)new TryPinPacket((byte)pin));
        return true;
    }

    public void handlePin(boolean correct, boolean reset) {
        this.pinTumblers[this.currPin].execute(MoveAction.at(0.0f, -6.0f).time(2), MoveAction.at(0.0f, 6.0f).time(2));
        this.upperPins[this.currPin].execute(MoveAction.at(0.0f, -6.0f).time(2));
        if (correct) {
            this.pins[this.currPin] = true;
            this.upperPins[this.currPin].execute(MoveAction.to(this.upperPins[this.currPin], this.upperPins[this.currPin].posX, 29.0f, 2));
        } else {
            this.upperPins[this.currPin].execute(MoveAction.at(0.0f, 6.0f).time(2));
        }
        if (reset) {
            this.resetSpeed();
            this.reset();
        }
    }

    public void reset() {
        for (int a = 0; a < this.pins.length; ++a) {
            if (!this.pins[a]) continue;
            this.pins[a] = false;
            this.upperPins[a].execute(MoveAction.to(this.upperPins[a], this.upperPins[a].posX, this.pinTumblers[a].posY - (float)this.UPPER_PIN_TEX.height, 2));
        }
        this.lockPick.alpha(0.0f);
        this.rightPickPart.alpha(1.0f).execute(WaitAction.ticks(10), FadeAction.to(this.rightPickPart, 0.0f, 4));
        this.leftPickPart.alpha(1.0f).execute(WaitAction.ticks(10), FadeAction.to(this.rightPickPart, 0.0f, 4).then(this.resetPickCb));
        this.frozen = true;
    }

    public void resetPick() {
        this.pickTex = LockPickingScreen.getTextureFor(Minecraft.m_91087_().f_91074_.m_21120_(this.hand));
        this.lockPick.position(-22 - this.LOCK_PICK_TEX.width, this.lockPick.posY).alpha(1.0f).execute(AccelerateAction.to(32.0f, 0.0f, 4, false).then(this.unfreezeCb));
    }

    public void resetSpeed() {
        for (Sprite sprite : this.sprites) {
            sprite.speedX = 0.0f;
            sprite.speedY = 0.0f;
            sprite.rotSpeed = 0.0f;
        }
    }
}

