/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.client.event;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import melonslise.locks.client.init.LocksRenderTypes;
import melonslise.locks.client.util.LocksClientUtil;
import melonslise.locks.common.capability.ILockableHandler;
import melonslise.locks.common.capability.ISelection;
import melonslise.locks.common.config.LocksClientConfig;
import melonslise.locks.common.config.LocksServerConfig;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.init.LocksItemTags;
import melonslise.locks.common.util.Lockable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(modid="locks", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class LocksClientForgeEvents {
    public static Lockable tooltipLockable;

    private LocksClientForgeEvents() {
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent e) {
        Minecraft mc = Minecraft.m_91087_();
        if (e.phase != TickEvent.Phase.START || mc.f_91073_ == null || mc.m_91104_()) {
            return;
        }
        ((ILockableHandler)mc.f_91073_.getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null)).getLoaded().values().forEach(lkb -> lkb.tick());
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderLevelStageEvent e) {
    }

    public static boolean holdingPick(Player player) {
        for (InteractionHand InteractionHand2 : InteractionHand.values()) {
            if (!player.m_21120_(InteractionHand2).m_204117_(LocksItemTags.LOCK_PICKS)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Pre e) {
        if (!((Boolean)LocksClientConfig.OVERLAY.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (tooltipLockable == null) {
            return;
        }
        if (LocksClientForgeEvents.holdingPick((Player)mc.f_91074_)) {
            PoseStack mtx = e.getGuiGraphics().m_280168_();
            Vector3f vec = LocksClientUtil.worldToScreen(LocksClientForgeEvents.tooltipLockable.getLockState((Level)mc.f_91073_).pos, e.getPartialTick());
            if ((double)vec.z() < 0.0) {
                mtx.m_85836_();
                mtx.m_252880_(vec.x(), vec.y(), 0.0f);
                LocksClientForgeEvents.renderHudTooltip(mtx, Lists.transform((List)LocksClientForgeEvents.tooltipLockable.stack.m_41651_((Player)mc.f_91074_, (TooltipFlag)(mc.f_91066_.f_92125_ ? TooltipFlag.f_256730_ : TooltipFlag.f_256752_)), Component::m_7532_), mc.f_91062_);
                mtx.m_85849_();
            }
        }
        tooltipLockable = null;
    }

    public static void renderLocks(PoseStack mtx, MultiBufferSource.BufferSource buf, Frustum ch, float pt) {
        Minecraft mc = Minecraft.m_91087_();
        Vec3 o = LocksClientUtil.getCamera().m_90583_();
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        double dMin = 0.0;
        for (Lockable lkb : ((ILockableHandler)mc.f_91073_.getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null)).getLoaded().values()) {
            Vec3 look;
            double d1;
            Lockable.State state = lkb.getLockState((Level)mc.f_91073_);
            if (state == null || !state.inRange(o) || !state.inView(ch)) continue;
            double d = o.m_82546_(state.pos).m_82556_();
            if (d <= 25.0 && (d1 = LocksClientUtil.distanceToLineSq(state.pos, o, look = o.m_82549_(mc.f_91074_.m_20252_(pt)))) <= 4.0 && (dMin == 0.0 || d1 < dMin)) {
                tooltipLockable = lkb;
                dMin = d1;
            }
            mtx.m_85836_();
            mtx.m_85837_(state.pos.f_82479_ - o.f_82479_, state.pos.f_82480_ - o.f_82480_, state.pos.f_82481_ - o.f_82481_);
            if (state.tr.face == AttachFace.CEILING) {
                mtx.m_252781_(new Quaternionf().rotateX(90.0f));
            } else if (state.tr.dir == Direction.WEST || state.tr.dir == Direction.EAST) {
                mtx.m_252781_(new Quaternionf().rotateY(1.6f));
            }
            if (state.tr.face == AttachFace.FLOOR) {
                mtx.m_252781_(new Quaternionf().rotateX(45.0f));
            }
            mtx.m_85837_(0.0, 0.1, 0.0);
            mtx.m_252781_(new Quaternionf().rotateZ(Mth.m_14031_((float)(LocksClientUtil.cubicBezier1d(1.0f, 1.0f, LocksClientUtil.lerp(lkb.maxSwingTicks - lkb.oldSwingTicks, lkb.maxSwingTicks - lkb.swingTicks, pt) / (float)lkb.maxSwingTicks) * (float)lkb.maxSwingTicks / 5.0f * 3.14f)) * 0.4f));
            mtx.m_85837_(0.0, -0.1, 0.0);
            mtx.m_85841_(0.5f, 0.5f, 0.5f);
            int light = LevelRenderer.m_109541_((BlockAndTintGetter)mc.f_91073_, (BlockPos)mut.m_122169_(state.pos.f_82479_, state.pos.f_82480_, state.pos.f_82481_));
            mc.m_91291_().m_269128_(lkb.stack, ItemDisplayContext.FIXED, light, OverlayTexture.f_118083_, mtx, (MultiBufferSource)buf, (Level)mc.f_91073_, 0);
            mtx.m_85849_();
        }
        buf.m_109911_();
    }

    public static void renderSelection(PoseStack mtx, MultiBufferSource buf) {
        Minecraft mc = Minecraft.m_91087_();
        Vec3 o = LocksClientUtil.getCamera().m_90583_();
        ISelection select = (ISelection)mc.f_91074_.getCapability(LocksCapabilities.SELECTION).orElse(null);
        if (select == null) {
            return;
        }
        BlockPos pos = select.get();
        if (pos == null) {
            return;
        }
        BlockPos pos1 = mc.f_91077_ instanceof BlockHitResult ? ((BlockHitResult)mc.f_91077_).m_82425_() : pos;
        boolean allow = Math.abs(pos.m_123341_() - pos1.m_123341_()) * Math.abs(pos.m_123342_() - pos1.m_123342_()) * Math.abs(pos.m_123343_() - pos1.m_123343_()) <= (Integer)LocksServerConfig.MAX_LOCKABLE_VOLUME.get() && LocksServerConfig.canLock((Level)mc.f_91073_, pos1);
        LevelRenderer.m_109608_((PoseStack)mtx, (VertexConsumer)buf.m_6299_(LocksRenderTypes.OVERLAY_LINES), (double)((double)Math.min(pos.m_123341_(), pos1.m_123341_()) - o.f_82479_), (double)((double)Math.min(pos.m_123342_(), pos1.m_123342_()) - o.f_82480_), (double)((double)Math.min(pos.m_123343_(), pos1.m_123343_()) - o.f_82481_), (double)((double)Math.max(pos.m_123341_(), pos1.m_123341_()) + 1.0 - o.f_82479_), (double)((double)Math.max(pos.m_123342_(), pos1.m_123342_()) + 1.0 - o.f_82480_), (double)((double)Math.max(pos.m_123343_(), pos1.m_123343_()) + 1.0 - o.f_82481_), (float)(allow ? 0.0f : 1.0f), (float)(allow ? 1.0f : 0.0f), (float)0.0f, (float)0.5f);
        RenderSystem.disableDepthTest();
    }

    /*
     * WARNING - void declaration
     */
    public static void renderHudTooltip(PoseStack mtx, List<? extends FormattedCharSequence> lines, Font font) {
        if (lines.isEmpty()) {
            return;
        }
        int width = 0;
        for (FormattedCharSequence formattedCharSequence : lines) {
            int j = font.m_92724_(formattedCharSequence);
            if (j <= width) continue;
            width = j;
        }
        int x = 36;
        int n = -36;
        int height = 8;
        if (lines.size() > 1) {
            height += 2 + (lines.size() - 1) * 10;
        }
        mtx.m_85836_();
        BufferBuilder buf = Tesselator.m_85913_().m_85915_();
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        LocksClientUtil.square(buf, mtx, 0.0f, 0.0f, 4.0f, 0.05f, 0.0f, 0.3f, 0.8f);
        LocksClientUtil.line(buf, mtx, 1.0f, -1.0f, (float)x / 3.0f + 0.6f, (float)n / 2.0f, 2.0f, 0.05f, 0.0f, 0.3f, 0.8f);
        LocksClientUtil.line(buf, mtx, (float)x / 3.0f, (float)n / 2.0f, (float)x - 3.0f, (float)n / 2.0f, 2.0f, 0.05f, 0.0f, 0.3f, 0.8f);
        LocksClientUtil.vGradient(buf, mtx, x - 3, n - 4, x + width + 3, n - 3, 0.0627451f, 0.0f, 0.0627451f, 0.9411765f, 0.0627451f, 0.0f, 0.0627451f, 0.9411765f);
        LocksClientUtil.vGradient(buf, mtx, x - 3, n + height + 3, x + width + 3, n + height + 4, 0.0627451f, 0.0f, 0.0627451f, 0.9411765f, 0.0627451f, 0.0f, 0.0627451f, 0.9411765f);
        LocksClientUtil.vGradient(buf, mtx, x - 3, n - 3, x + width + 3, n + height + 3, 0.0627451f, 0.0f, 0.0627451f, 0.9411765f, 0.0627451f, 0.0f, 0.0627451f, 0.9411765f);
        LocksClientUtil.vGradient(buf, mtx, x - 4, n - 3, x - 3, n + height + 3, 0.0627451f, 0.0f, 0.0627451f, 0.9411765f, 0.0627451f, 0.0f, 0.0627451f, 0.9411765f);
        LocksClientUtil.vGradient(buf, mtx, x + width + 3, n - 3, x + width + 4, n + height + 3, 0.0627451f, 0.0f, 0.0627451f, 0.9411765f, 0.0627451f, 0.0f, 0.0627451f, 0.9411765f);
        LocksClientUtil.vGradient(buf, mtx, x - 3, n - 3 + 1, x - 3 + 1, n + height + 3 - 1, 0.3137255f, 0.0f, 1.0f, 0.3137255f, 0.15686275f, 0.0f, 0.49803922f, 0.3137255f);
        LocksClientUtil.vGradient(buf, mtx, x + width + 2, n - 3 + 1, x + width + 3, n + height + 3 - 1, 0.3137255f, 0.0f, 1.0f, 0.3137255f, 0.15686275f, 0.0f, 0.49803922f, 0.3137255f);
        LocksClientUtil.vGradient(buf, mtx, x - 3, n - 3, x + width + 3, n - 3 + 1, 0.3137255f, 0.0f, 1.0f, 0.3137255f, 0.3137255f, 0.0f, 1.0f, 0.3137255f);
        LocksClientUtil.vGradient(buf, mtx, x - 3, n + height + 2, x + width + 3, n + height + 3, 0.15686275f, 0.0f, 0.49803922f, 0.3137255f, 0.15686275f, 0.0f, 0.49803922f, 0.3137255f);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderTexture((int)0, (int)0);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferUploader.m_231209_((BufferBuilder.RenderedBuffer)buf.m_231175_());
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.disableBlend();
        RenderSystem.setShaderTexture((int)0, (int)7424);
        MultiBufferSource.BufferSource buf1 = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        Matrix4f last = mtx.m_85850_().m_252922_();
        for (int a = 0; a < lines.size(); ++a) {
            FormattedCharSequence line = lines.get(a);
            if (line != null) {
                void var5_8;
                font.m_272191_(line, (float)x, (float)var5_8, -1, true, last, (MultiBufferSource)buf1, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
            if (a == 0) {
                var5_8 += 2;
            }
            var5_8 += 10;
        }
        buf1.m_109911_();
        mtx.m_85849_();
    }
}

