/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.fakeworld;

import blusunrize.immersiveengineering.common.util.fakeworld.TemplateChunkSection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;

public class TemplateChunk
extends LevelChunk {
    private final Predicate<BlockPos> shouldShow;
    private final Holder<Biome> biome;

    public TemplateChunk(Level worldIn, ChunkPos chunkPos, List<StructureTemplate.StructureBlockInfo> blocksInChunk, Predicate<BlockPos> shouldShow) {
        super(worldIn, chunkPos);
        Registry biomeRegistry = worldIn.m_9598_().m_175515_(Registries.f_256952_);
        for (int i = 0; i < this.m_7103_().length; ++i) {
            this.m_7103_()[i] = new TemplateChunkSection(i, (Registry<Biome>)biomeRegistry, shouldShow, chunkPos);
        }
        this.shouldShow = shouldShow;
        this.biome = worldIn.m_203675_(0, 0, 0);
        for (StructureTemplate.StructureBlockInfo info : blocksInChunk) {
            BlockEntity tile;
            this.actuallSetBlockState(info.f_74675_(), info.f_74676_());
            if (info.f_74677_() == null || (tile = BlockEntity.m_155241_((BlockPos)info.f_74675_(), (BlockState)info.f_74676_(), (CompoundTag)info.f_74677_())) == null) continue;
            tile.m_142339_(worldIn);
            this.m_62954_().put(info.f_74675_(), tile);
        }
    }

    @Nonnull
    public FluidState m_6425_(@Nonnull BlockPos pos) {
        return this.m_8055_(pos).m_60819_();
    }

    @Nullable
    public BlockEntity m_5685_(@Nonnull BlockPos pos, @Nonnull LevelChunk.EntityCreationType creationMode) {
        if (!this.shouldShow.test(pos)) {
            return null;
        }
        return (BlockEntity)this.m_62954_().get(pos);
    }

    @Nullable
    public BlockState m_6978_(@Nonnull BlockPos pos, @Nonnull BlockState state, boolean isMoving) {
        return null;
    }

    public void actuallSetBlockState(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        int sectionIndex = this.m_151564_(pos.m_123342_());
        int sectionX = pos.m_123341_() & 0xF;
        int sectionY = pos.m_123342_() & 0xF;
        int sectionZ = pos.m_123343_() & 0xF;
        TemplateChunkSection section = (TemplateChunkSection)this.m_183278_(sectionIndex);
        section.actuallySetBlockState(sectionX, sectionY, sectionZ, state);
    }

    public int m_7146_(@Nonnull BlockPos pos) {
        return 0;
    }

    public void m_142170_(@Nonnull BlockEntity blockEntity) {
    }

    public void m_142169_(@Nonnull BlockEntity blockEntity) {
    }

    public void m_8114_(@Nonnull BlockPos pos) {
    }

    public boolean m_6430_() {
        return false;
    }

    public boolean m_5566_(int startY, int endY) {
        return false;
    }

    @Nonnull
    public FullChunkStatus m_287138_() {
        return FullChunkStatus.INACCESSIBLE;
    }

    @Nonnull
    public Holder<Biome> m_203495_(int p_204426_, int p_204427_, int p_204428_) {
        return this.biome;
    }
}

